/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include "kernel/kernel.h"
#include "kernel/kprint.h"

#define DEVICE_UNLOAD_TIME 60	// Unload a dynmaic device after xx seconds

#define STATIC_DEVICE		1
#define NULL_DEVICE			0
#define SEQUENTIEL_DEVICE	2
#define RANDOM_DEVICE		4
#define FILESYSTEM_DEVICE	8

// This struct describes the device operations
typedef struct DeviceOps
{
 	// open
	// close
	// ioctl
	// read
	// write
	// seek
	// canunload
}  DeviceOps;

// This struct describes a device
typedef struct Device
{
  char 		Name [9];		// Name of the device
  byte		Type;				// sequentiel (char) or random (block) device
  ulong 	   LastUsed;		// Time of last operation (in ticks)
} Device;

// The current loaded devices list:


//////////////////////////////////////////////////////////////////
// public functions

// initialise the static (bootup) devices
void InitDevices (void)
{
 	;
}

// dynamical load a new device
void LoadDevice (const char *name)
{
 	name = name;
}

// unload a dynamic device
void UnloadDevice (const char *name)
{
 	name = name;
}

// unload all devices that have't used
void FreeDevices (void)
{
 	;
}

// A Device Driver calls this to register itself
int RegisterDevice (const char *name, byte type, DeviceOps *ops)
{
   name = name;
	type = type;
	ops  = ops;

 	return (1);
}

void DumpDeviceList (void)
{
}

