/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel lpt code.                      ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <kernel/kernel.h>
#include <kernel/selector.h>
#include <kernel/memmgmt.h>
#include <kernel/kprint.h>
#include <kernel/schedule.h>
#include <kernel/console.h>
#include <string.h>

extern int FloppyDiskReadBlock (int, char *);

int RamDiskWriteBlock (int Nr, char *Buffer);

int   SizeOfRamdisk = 1474560; // 1.44 MB
char *RamDisk = 0;

///////////////////////////////////////////////////////////////////////////
void InitRamdisk (void)
{
 	kprintf ("Sizeof ramdisk = %d kBytes\n",  SizeOfRamdisk / 1024);

	memset (RamDisk, 0, SizeOfRamdisk);
}

int RamDiskReadBlock (int Nr, char *Buffer)
{
 	if (!RamDisk)
	  	return (0);
   if (Nr < 0 || Nr >= (SizeOfRamdisk / 512))
	  return (0);

   memcpy (Buffer, RamDisk + Nr * 512, 512);

	return (512);
}

int RamDiskWriteBlock (int Nr, char *Buffer)
{
 	if (!RamDisk)
	  	return (0);
   if (Nr < 0 || Nr >= (SizeOfRamdisk / 512))
	  return (0);

   memcpy (RamDisk + Nr * 512, Buffer, 512);

	return (512);
}

volatile int RamdiskLoaded = 0;

void LoadRamdisk (void)
{
 	char Buffer[512];
	int  i;

	RamdiskLoaded = 1;

/* TODO: load a floppy image into the ramdisk, so that we can work with it
 	kprintf ("trying to load floppy into ramdisk");
	for (i = 0; i < 1; i++) // (SizeOfRamdisk / 512); i++)
	{
	 	if (! (i % 200))
		  kprintf (".");

	 	if (FloppyDiskReadBlock (i, Buffer) < 0)
		   break;
      else
			RamDiskWriteBlock (i, Buffer);

		if (i == 0)
		{
		 	int j;
		 	int con = GetCurrentConsole ();
			SwitchToConsole (2);

			GotoXY(0,0);

			for (j = 0; j < 511; j++)
				kprintf ("%c", Buffer[j]);

			SwitchToConsole (con);
		}
	}

	RamdiskLoaded = 1;

 	kprintf ("\n");
*/
}

