/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel keyboard code.                 ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  03. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#ifndef __KEYBOARD_H
#define __KEYBOARD_H

#define KBD_NOMODIFIER   0
#define KBD_SHIFT        1
#define KBD_LEFTSHIFT    2
#define KBD_RIGHTSHIFT   4
#define KBD_CTRL         8
#define KBD_LEFTCTRL    16
#define KBD_RIGHTCTRL   32
#define KBD_ALT         64
#define KBD_ALTGR      128

/*
 * Setup the keyboard
 */
extern void InitKeyboard (void);

/*
 * wait for the next key
 */
extern int getch (void);

/*
 * read the next Key (returns -1 if there is none)
 */
extern int GetKey (void);

/*
 * Reboot the machine
 */
extern void Reboot (int DoColdBoot);

/*
 * Set a kernel hotkey
 *
 * Arguments:
 *  SCANCODE of Hotkey
 *  Modifiers (CTRL, ALT, ...) in any kombination
 *  Function to call
 *
 * WARNING the function will be called at interrupt level!
 */
extern int SetHotkey (int ScanCode, byte Modifier, void (*fnc)(void));

extern void SetDebuggerHotkey (int ScanCode, byte Modifier, void (*fnc)(IntRegs *, int));
/*
 * This function is only for use by the kernel debugger !!
 *
 * The keyboard is polled, so no IRQ's are needed.
 * If 'WaitForKey' is 1 then the functiontion will wait for the next
 * key, otherwise it will return -1.
 */
extern int GetKeyForDebugger (int WaitForKey);

#endif // __KEYBOARD_H
