/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel multitasking code.             ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  10. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#ifndef __SCHEDULE_H
#define __SCHEDULE_H

#define NR_OF_TASKS           512   // max. # of Tasks in Usermode
#define NR_OF_KERNEL_TASKS     20   // max # of Tasks in Kernel mode

// The Task States
#define TASKFREE        0  // Task is not assigned
#define TASKREADY       1  // Task is ready to run
#define TASKWAITING     2  // Task is waiting for an Event
#define TASKNOTWAITING  3  // Event for task has arrived
#define TASKSLEEPING    4  // this task is sleeping

typedef struct Task
{
   ulong		   		pid;				// Task process id
   ulong		   		lasteip;			// last EIP
   int	           	State;		   // Current state of the task
   int	           	Counter;		   //
   int	           	Priority;	   //
	ulong				   TimeToWakeup;	// time to wakeup a sleeping task
	int					CurrentConsole;

   void            (*StartFnc)(void);
   unsigned long   	TimeInTask;    //
   unsigned long   	TimeInKernel;  //

   unsigned short  	TSSSel;     	// TSS Selektor
   tss			   	TaskTSS;			// and the TSS itself

   struct Task	  *NextTask;			//
} Task ;

#define nop() __asm__ __volatile__ ("nop")
#define sti() __asm__ __volatile__ ("sti": : :"memory")
#define cli() __asm__ __volatile__ ("cli": : :"memory")

#define save_flags(x) \
__asm__ __volatile__("pushfl ; popl %0":"=g" (x): /* no input */ :"memory")

#define restore_flags(x) \
__asm__ __volatile__("pushl %0 ; popfl": /* no output */ :"g" (x):"memory")


extern int  InIdleTask         (void);
extern int  TimeCurrentTask    (void);
extern int  NeedSchedule       (void);
extern void RequestReschedule  (void);
extern void Schedule           (void);
extern void Sleep 				 (int);

extern void InitKernelTasking  (void);

extern int  CreateKernelTask   (void (*fnc)(void), int Priority);

extern Task *GetCurrentTask    (void);

extern void DumpTaskStatistic  (void);

#endif // __SCHEDULE_H

