/****************************************************************************/
/*** This file contains gdt selector definitions used by the loader       ***/
/*** If you need other selector assignments, change this file at will     ***/
/***    Copyright (C) 1997 by Joachim Breitsprecher                       ***/
/***       email: j.breitsprecher@schwaben.de                             ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***  Joachim Breitsprecher (HJB)                                         ***/
/***      <j.breitsprecher@schwaben.de>                                   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  22. Feb 1997  Coding started (HJB)                                  ***/
/***                                                                      ***/
/*** NOTE: SEL_DUMMYTSS will be discarded again after switching to PM and ***/
/***       calling the kernel entry point, as it is only needed to allow  ***/
/***       task switching. Thus it can be the same number as any other    ***/
/***       selector that is NOT used before task switching (eg. the LDT)  ***/
/****************************************************************************/
#define	SEL_NULL		0x0000		// The NULL selector (may never be used)
#define SEL_GDT			0x0008		// A selector for the GDT itself
#define SEL_IDT			0x0010		// Selector for the IDT
#define SEL_CLINEAR		0x0018		// A 4GB executable segment with base 0
#define SEL_DLINEAR		0x0020		// A 4GB data segment with base 0
#define	SEL_CKERNEL		0x0028		// This is the kernel segment (code)
#define SEL_DKERNEL		0x0030		// The above marked as data segment
#define SEL_KERNELTSS	0x0038		// The kernel's task state segment
#define SEL_DUMMYTSS	0x0040		// Will be discarded after task switch
#define SEL_KERNELLDT	0x0040		// The kernel's local descriptor table

/* Exception handler task state segments */
#define TSS_EXC00		0x0100
#define TSS_EXC01		0x0108
#define TSS_EXC02		0x0110
#define TSS_EXC03		0x0118
#define TSS_EXC04		0x0120
#define TSS_EXC05		0x0128
#define TSS_EXC06		0x0130
#define TSS_EXC07		0x0138
#define TSS_EXC08		0x0140
#define TSS_EXC09		0x0148
#define TSS_EXC0A		0x0150
#define TSS_EXC0B		0x0158
#define TSS_EXC0C		0x0160
#define TSS_EXC0D		0x0168
#define TSS_EXC0E		0x0170
#define TSS_EXC0F		0x0178
#define TSS_EXC10		0x0180
#define TSS_EXC11		0x0188
#define TSS_EXC12		0x0190
#define TSS_DUMMY		0x0198		// Used for return from exception

