/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  10. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <kernel/kernel.h>
#include <kernel/waitq.h>
#include <kernel/schedule.h>

#define countof(x) (sizeof(x) / sizeof(*x))

static void AddToWaitQueue (WaitQ **queue, WaitQ *wait)
{
   int flags;

   save_flags (flags);
   cli ();

	if (! *queue)
	{
		wait->next = wait;
		*queue = wait;
	}
	else
	{
		wait->next = (*queue)->next;
		(*queue)->next = wait;
	}

   restore_flags (flags);
}

static void RemoveFromWaitQueue (WaitQ **queue, WaitQ *wait)
{
	struct WaitQ *tmp;
   long flags;

   save_flags (flags);
   cli ();

	if ((*queue == wait) && ((*queue = wait->next) == wait))
	{
		*queue = 0;
	}
	else
	{
		tmp = wait;
		while (tmp->next != wait)
		{
			tmp = tmp->next;
		}
		tmp->next = wait->next;
	}
	wait->next = 0;

   restore_flags (flags);
}

/////////////////////////////////////////////////////////////////////
// public Funktions

void SleepOn (WaitQ **queue)
{
   WaitQ  wait;
   Task  *task;

   if (! queue)
      return;

   if (InIdleTask())
      return;

   wait.WaitingTask = task = GetCurrentTask ();
   task -> State = TASKWAITING;

   wait.next        = 0;

   AddToWaitQueue (queue, &wait);

   Schedule ();

   RemoveFromWaitQueue (queue, &wait);

   return;
}

void WakeUp (WaitQ **queue)
{
   WaitQ *next;
   Task  *task;

   if (!queue || !*queue)
      return;

   next = *queue;

   do
   {
      task = next -> WaitingTask;

      if (task && task -> State == TASKWAITING)
      {
         task -> State = TASKREADY;

         if (task -> Counter > GetCurrentTask() -> Counter)
         {
            RequestReschedule ();
         }
      }

      next = next -> next;
   } while (next != *queue);

   return;
}


