/* Copyright (C) 1994 DJ Delorie, see COPYING.DJ for details */
/* by Breyten Ernsting <pinbrn@xs4all.nl> for Freedows kernel */
/* descriptions of these standard C functions can be found in any C book
*/
/* most of this is copied with minor modifications from the DJGPP source'
  see copyright above */
/* Martin Kortmann also worked on this part */
#include <string.h>
#include <libc/unconst.h>

void *
memchr(const void *s, int c, size_t n)
{
  if (n)
  {
    const char *p = s;
    do {
      if (*p++ == c)
	return unconst(p-1, void *);
    } while (--n != 0);
  }
  return 0;
}

int
memcmp(const void *s1, const void *s2, size_t n)
{
  if (n != 0)
  {
    const unsigned char *p1 = s1, *p2 = s2;

    do {
      if (*p1++ != *p2++)
	return (*--p1 - *--p2);
    } while (--n != 0);
  }
  return 0;
}

void *  memcpy(void *dest, const void *src, size_t n)
{
	char *p1 = dest;
	const char *p2 = src;

	if (n)
	{
		n++;
		while (--n > 0)
		{
			*p1++ = *p2++;
		}
	}
	return (dest);
}

void *  memmove(void *s1, const void *s2, size_t n)
{
	char *p1 = s1;
	const char *p2 = s2;

	if (n>0)
	{
		if (p2 <= p1 && p2 + n > p1)
		{
			p1 += n;
			p2 += n;
			n++;
			while (--n > 0)
			{
				*--p1 = *--p2;
			}
		}
		else
		{
			n++;
			while (--n > 0)
			{
				*p1++ = *p2++;
			}
		}
	}
	return (s1);
}
void * memset(void *s, int c, size_t n)
{
	char *s1 = (char *) s;

	while (n-- > 0)
		*s1++ = (char) c;

	return (s);
}

