/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <string.h>

void * memmove(void *s1, void *s2, int n)
{
	char *p1 = s1;
	const char *p2 = s2;

	if (n>0)
	{
		if (p2 <= p1 && p2 + n > p1)
		{
			p1 += n;
			p2 += n;
			n++;
			while (--n > 0)
			{
				*--p1 = *--p2;
			}
		}
		else
		{
			n++;
			while (--n > 0)
			{
				*p1++ = *p2++;
			}
		}
	}
	return (s1);
}
