/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <string.h>

char *strtok(char *s, const char *delim)
{
	const char *spanp;
	int c, sc;
	char *tok;
	static char *last = 0;

	if (s == 0 && (s = last) == 0)
		return (0);

cont:
	c = *s++;
	for (spanp = delim; (sc = *spanp++) != 0;)
	{
		if (c == sc)
			goto cont;
	}

	if (c == 0)
	{
		last = 0;
		return (0);
	}
	tok = s - 1;

	for (;;)
	{
		c = *s++;
		spanp = delim;
		do
		{
			if ((sc = *spanp++) == c)
			{
				if (c == 0)
					s = 0;
				else
					s[-1] = 0;
				last = s;
				return (tok);
			}
		} while (sc != 0);
	}
	/* NOTREACHED */
}

