;/***************************************************************************/
;/*** Freedows '98 Cache Kernel Loader -- Assembler Module                ***/
;/***    Copyright (C) 1997 by Joachim Breitsprecher                      ***/
;/***       email: j.breitsprecher@schwaben.de                            ***/
;/***                                                                     ***/
;/***    This file is part of the Freedows '98 Project                    ***/
;/***************************************************************************/
;/*** Contributors: (If you modify this, please put your name/email here  ***/
;/***  Joachim Breitsprecher (HJB)                                        ***/
;/***      <j.breitsprecher@schwaben.de>                                  ***/
;/***                                                                     ***/
;/*** File History: (Please record any changes here)                      ***/
;/***  22. Feb 1997  Coding started (HJB)                                 ***/
;/***************************************************************************/
				.model	large,C

				.386p
				LOCALS

				PUBLIC	Is386
				PUBLIC	IsPM
				PUBLIC	GoPM
				PUBLIC	EnableA20

				EXTRN	kernelptr
				EXTRN	GDTPtr		: pword
				EXTRN	dummysel	: word
				EXTRN	PLin		: dword

				.code
;// This function tries to enable the address line A20
EnableA20		proc
				push	cx
				push	dx

				mov		dx,1		;// assume success
				cli

				call	A20test		;// is A20 already enabled?
				jz		@@done		;// if yes, done

				in		al,92h		;// PS/2 A20 enable
				or		al,2
				jmp		$+2
				jmp		$+2
				jmp		$+2
				out		92h,al

				call	A20test		;// is A20 enabled?
				jz		@@done		;// if yes, done

				call	kbwait		;// AT A20 enable
				jnz		@@f0

				mov		al,0d1h
				out		64h,al

				call	kbwait
				jnz		@@f0

				mov		al,0dfh
				out		60h,al

				call	kbwait

@@f0:								;// wait for A20 to enable
				mov		cx,800h		;// do 800h tries

@@l0:			call	A20test		;// is A20 enabled?
				jz		@@done		;// if yes, done

				in		al,40h		;// get current tick counter
				jmp		short $+2
				jmp		short $+2
				jmp		short $+2
				in		al,40h
				mov		ah,al

@@l1:								;// wait a single tick
				in		al,40h
				jmp		$+2
				jmp		$+2
				jmp		$+2
				in		al,40h
				cmp		al,ah
				je		@@l1

				loop	@@l0		;// loop for another try

				mov		dx,0
@@done:			mov		ax,dx
				pop		dx
				pop		cx
				ret
EnableA20		endp

;// *** wait until it is safe to write to 8042
kbwait			proc	near
				xor		cx,cx
@@0:			jmp		$+2
				jmp		$+2
				jmp		$+2
				in		al,64h		;// read 8042 status
				test	al,2		;// buffer full?
				loopnz	@@0			;// if yes, loop
				ret
kbwait			endp

;// ** test for enabled A20
A20test			proc	near
				push	ds
				push	es

				xor		ax,ax		;// set A20 test segments 0 and 0ffffh
				mov		ds,ax
				dec		ax
				mov		es,ax

				mov		al,[ds:0]	;// get byte from 0:0
				mov		ah,al		;// preserve old byte
				not		al			;// modify byte
				xchg	al,[es:10h]	;// put modified byte to 0ffffh:10h
				cmp		ah,[ds:0]	;// set zero if byte at 0:0 not modified
				mov		[es:10h],ah	;// put back old byte at 0ffffh:10h

				pop		es
				pop		ds
				ret					;// return, zero if A20 enabled
A20test			endp

;// Is386 checks if the installed CPU is a 386 or higher
Is386			proc
				pushf
				cli
;// First check for 80(1)86/88: These CPUs always set bits 12-15 in flags
				pushf
				pushf
				pop		ax
				and		ax,00FFFh
				push	ax
				popf
				pushf
				pop		ax
				popf				;// Restore flags
				and		ax,0F000h	;// Test bits 12-15
				cmp		ax,0F000h	;// All set?
				je		@@No386		;// Yes, it is indeed a 80(1)86/88 :P

;// Now check if we have a 286 or at least a 386. The 286 sets bits 12-14
;// to zero.
				pushf
				pushf
				pop		ax
				or		ax,07000h
				push	ax
				popf
				pushf
				pop		ax
				popf				;// Restore flags
				test	ax,07000h	;// Test bits 12-14
				jz		@@No386		;// Yes, we have an old-fashioned 286! :(

				mov		ax,1		;// return TRUE
				popf
				ret

@@No386:		mov		ax,0		;// return FALSE
				popf
				ret
Is386			endp

;// IsPM checks if the CPU is in Protected or Virtual86 Mode
IsPM			proc
				smsw	ax			;// Get CR0 (Machine Status Word)
				and		ax,1		;// Isolate bit 0 (Protection Enable)
				ret
IsPM			endp

;// This function will switch to PM and execute the kernel
GoPM			proc
				cli					;// Close down all interrupts

				mov		eax,dword ptr [kernelptr]
				mov		dword ptr cs:[kernel],eax

				mov		bx,[dummysel]


;				mov		eax,PLin
;				mov		cr3,eax		;// Set CR3 (Page Dir Base Register)

				lgdt	GDTPtr      ;// Load GDTR with address of GDT
									;// NOTE: IDT will be set up when in PM!
				mov		eax,cr0		;// Get CR0
				or		eax,1		;// Set PE (Protection Enable) bit
;				or		eax,080000000h ;// Enable Paging
				mov		cr0,eax

@@1:			mov		ax,020h
				mov		ds,ax
				mov		es,ax
				mov		fs,ax
				mov		gs,ax

				ltr		bx

				xor		ax,ax
				lldt	ax			;// We do not yet have a LDT

				mov		word ptr fs:[0b8000h],01f30h

;// Call the kernel via task switch
				jmp		dword ptr cs:[kernel]

kernel:			dw		0,0

GoPM			endp

				end
