/*           Archivo (disco_kmos)\KMOSC\DEMOS\MENSAJE.C                   */
/* Un proceso, p1, similar a p1 en RETARDO1.C, que utiliza paso de        */
/* mensajes para comunicarse con el procreso IMPRIMIR que muestra en      */
/* pantalla los mensajes recibidos usando DOS int 21/S9.                  */
/* Por favor consulte los comentarios de RETARDO1.C para obtener          */
/* explicaciones adicionales                                              */

#include "kmospub.h"               /* declaraciones de servicios KMOS     */
#include <dos.h>                   /* inclusion para llamadas a  DOS/BIOS */
#include <string.h>                /* ... para manipulacion de cadenas    */
#include <alloc.h>                 /* ... para asignacion de memoria      */
  
palabra _stklen = 32767;           /* definir tamao de pila              */

#define true 1                     /* valor lgico cierto                 */
#define cip01 0x21                 /* control int. progr. PC, reg ordenes */
#define tecla_y_disco 0xbd         /* cte. habilita ints TECLADO y DISCO  */
#define imprcadena 9               /* no. servicio DOS imprimir cadenas   */
#define byte unsigned char         /* define byte como unsigned char      */

union REGS regspp;                 /* estructuras DOS.H para acceso a regs*/
struct SREGS sregspp;

struct imprmensaje                /* Mensaje utilizado para comunicar una */
{                                 /* cadena de salida de hasta 10 caract. */
   char salida[10];                    /* al servidor IMPRIMIR            */
   int  longitud;
};
typedef struct imprmensaje * ptrimpr;  /*puntero a tipo de mensaje impr   */

void *imprbuzon;                       /* buzon para imprimir             */

/* INTOFF y INTON: procedimientos identicos a los homonimos en KMOS  */
#define inton asm sti                  /* STI, permitir interrupciones    */
#define intoff asm cli                 /* CLI, prohibir interrupciones    */

void p1()                    /* proceso de usuario P1 */
{
   k_ptrmens imprmensaje;              /* variable mensaje efectivo       */
   ptrimpr imprsal;                    /* y puntero asociado              */

   while (true)                        /* bucle sin fin */
   {
      k_retardar(50);                /* llamada a KMOS; retardar 50 tics  */
      intoff;                        /* seccion critica - manip. del heap */
      /* obtener espacio para el mensaje y su contenido */
      imprmensaje = (k_ptrmens) malloc(sizeof(struct k_mens)); /* mensaje */
      imprsal = (ptrimpr) malloc(sizeof(struct imprmensaje)); /*contenido */
      inton;
      imprmensaje->enlace = NULL;      /* inicializar campos del mensaje  */
      imprmensaje->mtipo = 0;          /* tipo de mensaje normal          */
      strncpy(imprsal->salida, "1234 $", 6); /* ASCII para enviar         */
      imprsal->longitud = 6;           /* longitud = 4 alfa + espacio + $ */
      imprmensaje->cuerpo = imprsal;   /* el mensaje apunta al contenido  */
      k_enviar(imprbuzon, imprmensaje); /* llamada a KMOS: enviar mensaje */
   }
}

void imprimir()                 /* servidor IMPRIMIR */
{
   byte salvamascara;                  /* variables locales de imprimir   */
   k_ptrmens imprmensaje;              /* su propio puntero a mensaje     */
   ptrimpr imprsal;                    /* puntero al contenido que manip. */

   while (true)                     /* servidor siempre listo para servir */
   {
      imprmensaje = k_recibir(imprbuzon, 0);  /* recibir de cualquiera    */
      imprsal = imprmensaje->cuerpo;   /* apuntar al contenido            */
      salvamascara = inportb(cip01);   /* manipulacion de CIP para        */
      outportb(cip01, tecla_y_disco);  /*deshabilitar ints dentro de BIOS */
      regspp.h.ah = 9;                 /* DOS/BIOS INT 21/9 = imprimir    */
      regspp.x.dx = FP_OFF(imprsal->salida); /* ds:dx apunta a la cadena  */
      sregspp.ds = FP_SEG(imprsal->salida);
      intdosx(&regspp, &regspp, &sregspp); /* llamada al BIOS             */
      free(imprsal);                   /* libera el espacio del contenido */
      free(imprmensaje);               /* y el espacio del mensaje        */
      outportb(cip01, salvamascara);   /* restaurar mascar/interr. CIP    */
   }                                   /* esperar a otra peticion         */
}

void main()
{
   kmosinicial();                      /* inicializar KMOS             */

   /* Crear procesos de usuario */
   k_crearproc(p1, "P1", 256, 150);
   k_crearproc(imprimir, "IMPRIMIR", 256, 200);
   imprbuzon = k_crearbuzon();         /* crear buzon para impresiones */
   kmosiniciar();                      /* iniciar el sistema operativo */
}
