/*         Archivo (disco_kmos)\KMOSC\DEMOS\RETARDO1.C              */
/* Diseo en Turbo C de la tarea RETARDO1, ejercicio 11.9 del libro.*/
/* Cada uno de los tres procesos de usuario incluidos se retarda un */
/* cierto periodo de tiempo, y luego visualiza su numero ID en la   */
/* pantalla para identificarse. Puesto que no hay rutinas de        */
/* dispositivos en esta implementacion de KMOS, los procesos de     */
/* usuario utilizan la interrupcion DOS 21h, servicio 9 para        */
/* visualizar cadenas de caracteres. Mientras esta activa la E/S    */
/* del DOS, se deshabilitan las interrupciones con el fin de evitar */
/* posibles discrepancias causadas por la habilitacion de           */
/* interrupciones por parte del DOS/BIOS.                           */

#include "kmospub.h"         /* Declaraciones de servicios de KMOS        */
#include <dos.h>             /* inclusion para llamadas al DOS/BIOS       */
#include <string.h>          /* ... para manipulacion de cadenas          */

palabra _stklen = 32767;        /* definir tamao de pila                 */

#define true 1               /* Valor logico cierto                       */
#define cip01 0x21           /* controlador de int. progr. del PC,        *
                              * registro de ordenes                       */
#define tecla_y_disco 0xbd   /* constante para habilitar las ints de      *
                              * teclado y disco del PC                    */
#define imprcadena 9         /* Numero del servicio DOS imprimir cadena   */
#define byte unsigned char   /* definir byte como caracter sin signo      */

union  REGS  regsp1,  regsp2,  regsp3; /* variables de registros, DOS.H   */
struct SREGS sregsp1, sregsp2, sregsp3;
char mensp1[3], mensp2[3], mensp3[4];  /* cadenas/mensajes a visualizar   */

void p1()                    /* proceso de usuario P1 */
{
   byte salvamascara;               /* variable local: salvar mascara     */

   strncpy(mensp1, "1 $", 3);       /* inicializa el cuerpo del mensaje_1*/
   while (true)                     /* parte repetitiva           */
   {
      k_retardar(60);               /* llamada a KMOS; retardar 60 tics   */
      salvamascara = inportb(cip01);/* salvar la mascara actual de interr.* 
                                     * del sistema                        */
      outportb(cip01, tecla_y_disco); /* deshabilitar todas las interrupc.*
                   * menos las de teclado+disco para evitar discrepancias *
                   * con las interrupciones habilitadas por el BIOS       */
      regsp1.h.ah =imprcadena;      /* llamada DOS INT 21h, servicio 9h   */
      sregsp1.ds = FP_SEG(mensp1);  /* = imprimir cadena                  */
      regsp1.x.dx = FP_OFF(mensp1);
      intdosx(&regsp1, &regsp1, &sregsp1);
      outportb(cip01, salvamascara); /* restaurar la mascara de int. DOS  */
   }
}

void p2()                    /* proceso de usuario P2 */
{
   byte salvamascara;               /* variable local: salvar mascara     */

   strncpy(mensp2, "2 $", 3);       /* inicializar el cuerpo del mensaje_2*/
   while (true)                     /* parte repetitiva           */
   {
      k_retardar(95);               /* llamada a KMOS; retardar 95 tics   */
      salvamascara = inportb(cip01);/* salvar la mascara actual de interr.* 
                                     * del sistema                        */
      outportb(cip01, tecla_y_disco); /* deshabilitar todas las interrupc.*
                   * menos las de teclado+disco para evitar discrepancias */
                  /* con las interrupciones habilitadas por el BIOS       */
      regsp2.h.ah =imprcadena;       /* llamada DOS INT 21h, servicio 9h  */
      sregsp2.ds = FP_SEG(mensp2);   /* = imprimir cadena                 */
      regsp2.x.dx = FP_OFF(mensp2);
      intdosx(&regsp2, &regsp2, &sregsp2);
      outportb(cip01, salvamascara); /* restaurar la mascara de int. DOS  */
   }
}

void p3()                    /* proceso de usuario P3 */
{
   byte salvamascara;               /* variable local: salvar mascara     */

   mensp3[0] = '3';                 /* inicializar el cuerpo del mensaje_3*/
   mensp3[1] = '\r';                /* retorno de carro y                 */
   mensp3[2] = '\n';                /* salto-linea para terminar la linea */
   mensp3[3] = '$';                 /* terminador de cadena DOS, ASCII $  */
   while (true)                     /* parte repetitiva                   */
   {
      k_retardar(110);              /* llamada a KMOS; retardar 110 tics  */
      salvamascara = inportb(cip01);/* salvar la mascara actual de interr.* 
                                     * del sistema                        */
      outportb(cip01, tecla_y_disco); /* deshabilitar todas las interrupc.*
                   * menos las de teclado+disco para evitar discrepancias */
                  /* con las interrupciones habilitadas por el BIOS       */
      regsp3.h.ah =imprcadena;      /* llamada DOS INT 21h, servicio 9h   */
      sregsp3.ds = FP_SEG(mensp3);  /* = imprimir cadena                  */
      regsp3.x.dx = FP_OFF(mensp3);
      intdosx(&regsp3, &regsp3, &sregsp3);
      outportb(cip01, salvamascara); /* restaurar la mascara de int. DOS  */
   }
}

void main()                      /* codigo de usuario - seccion principal */
{
   kmosinicial();                        /* inicializar KMOS              */
   /* crear conjunto inicial de procesos usuarios (todos en este ejemplo) */
   k_crearproc(p1, "P1", 128, 150);      /* p1 = prioridad 150            */
   k_crearproc(p2, "P2", 128, 130);      /* pri(p2) = 130                 */
   k_crearproc(p3, "P3", 128, 140);      /* pri(p3) = 140                 */
   kmosiniciar();                        /* iniciar KMOS                  */
}
