
; Kernel stub. Compile in nasm 0.94+
; Copyright (c) 1997 Josh McDonald
; http://www.effect.net.au/os-dev/
; mailto:os-dev@effect.net.au

; Contains a20 code from pmode307b by Tran.

; Assemble to a .bin file.

;
; 16-bit entry code.
;


[org 0x100]
[bits 16]

jmp entry16

        original_int0:  dd 0

        gdt:

        gdt_limit       dw 31
        gdt_base        dd 0

        zero_sel        dd 0
                        dd 0
        
        code32_limit1   dw 0xffff
        code32_base1    dw 0
        code32_base2    db 0
        code32_type1    db 10011010b
        code32_type2    db 11001111b
        code32_base3    db 0

        selzero_limit1  dw 0xffff
        selzero_base1   dw 0
        selzero_base2   db 0
        selzero_type1   db 10010010b
        selzero_type2   db 11001111b
        selzero_base3   db 0

        selds_limit1    dw 0xffff
        selds_base1     dw 0
        selds_base2     db 0
        selds_type1     db 10010010b
        selds_type2     db 11001111b
        selds_base3     db 0

        selds16_limit1  dw 0xffff
        selds16_base1   dw 0
        selds16_base2   db 0
        selds16_type1   db 10000010b
        selds16_type2   db 00000000b  

        selcs16_limit1  dw 0xffff
        selcs16_base1   dw 0
        selcs16_base2   db 0
        selcs16_type1   db 10010010b
        selcs16_type2   db 00000000b  

        code32_sel      equ 8
        selzero         equ 0x10
        selds           equ 0x18
        selds16         equ 0x20
        selcs16         equ 0x28

        pmode_msg       db 'Sorry, detected v86 mode!',13,10,'$'

%include "font.inc"

entry16:
        mov ax,0x1100           ;Set font!
        push cs
        pop es
        mov bp,font
        xor dx,dx
        xor bl,bl
        mov cx,256
        mov bh,16
        int 0x10

        mov ax,0x0100           ;Set big cursor
        mov ch,0
        mov cl,0x0f
        int 0x10

        cli			;No more ints thanks..

        push cs
        pop ds

        push cs                 ;Calc code32's start base address.
        xor eax,eax
        pop ax

        shl eax,4
        mov edx,code32_starts
        add eax,edx


        ;The following code will be made obsolete soon, once fully
        ;dos compatible.

        xor dx,dx               ;We need to save the base address at 0:0
        mov es,dx               ;So the kernel can find it!
        mov ebx,[es:0]          ;We're gonna save int 0 so we can exit
                                ;To DOS l8r.
        mov [original_int0],ebx 
        mov [es:0],eax          

        mov [code32_base1],ax   ;The code will be in <16mb, so we only need
        mov [selds_base1],ax    ;Low 24 bits.
        shr eax,16              ;We're gonna make selds point to code32.
        mov [code32_base2],al
        mov [selds_base2],al

        xor eax,eax             ;Calc gdt's address.
        push cs
        pop ax
        mov edx,zero_sel
        shl eax,4
        add eax,edx
        mov [gdt_base],eax

        xor eax,eax             ;Set up stack for pmode.
        push cs
        pop ax
        shl ax,4
        mov edx,stack
        add eax,edx
        mov esp,eax

        smsw ax                 ;Detect pmode existence.
        and al,1
        jz no_pmode

        mov dx,pmode_msg        ;If we have pmode, we have dos, no?
        mov ax,0x0900
        int 0x21
        mov ax,0x4c00
        int 0x21

        no_pmode:		;Turn on A20. Stolen  from Jan ;-)


 ; We're gonna remap the PIC so IRQ0 is say 32
        ; That means Low IRQs are 32-39
        ; We're Also mapping the slave Pic to 40
        ; So thats 40-47
        ; Right at the end of the Interrupt Table out of the way of usefull
        ; BIOS/CPU interrupts
        ; Reprogram Master PIC (0-7)
        Mov  al, 10001b   ; ICW1: Bit 0 - Requires ICW4
        Out  20h, al      ; Need ICW4 because were running on 8086+ machines
        Mov  al, 32
        Out  21h, al
        Mov  al, 10000000b
        out  21h, al
        Mov  al, 1
        Out  21h, al       ; ICW4: 8086 Mode
        ; Reprogram Slave PIC (8-15)
        Mov  al, 10001b    ; ICW1: Bit 0 - Requires ICW4
        Out  0A0h, al      ; Need ICW4 because were running on 8086+ machines
        Mov  al, 40
        Out  0A1h, al
        Mov  al, 7
        out  0A1h, al
        Mov  al, 1
        Out  0A1h, al       ; ICW4: 8086 Mode



enablea20:                              ; hardware enable gate A20
        pushf
        push fs
        push gs
        cli

        xor ax,ax                       ; set A20 test segments 0 and 0ffffh
        mov fs,ax
        dec ax
        mov gs,ax

        call enablea20test              ; is A20 already enabled?
        jz short __enablea20done        ; if yes, done

        in al,92h                       ; PS/2 A20 enable
        or al,2
        jmp short $+2
        jmp short $+2
        jmp short $+2
        out 92h,al

        call enablea20test              ; is A20 enabled?
        jz short __enablea20done        ; if yes, done

        call enablea20kbwait            ; AT A20 enable
        jnz short __enablea20f0

        mov al,0d1h
        out 64h,al

        call enablea20kbwait
        jnz short __enablea20f0

        mov al,0dfh
        out 60h,al

        call enablea20kbwait

__enablea20f0:                          ; wait for A20 to enable
        mov cx,800h                     ; do 800h tries

__enablea20l0:
        call enablea20test              ; is A20 enabled?
        jz __enablea20done              ; if yes, done

        in al,40h                       ; get current tick counter
        jmp short $+2
        jmp short $+2
        jmp short $+2
        in al,40h
        mov ah,al

__enablea20l1:                          ; wait a single tick
        in al,40h
        jmp short $+2
        jmp short $+2
        jmp short $+2
        in al,40h
        cmp al,ah
        je __enablea20l1

        loop __enablea20l0              ; loop for another try

        mov ax,0x12
        int 0x10
        mov ax,0x4c00
        int 0x21

__enablea20done:
        pop gs
        pop fs
        popf
        jmp finished_a20

;-----------------------------------------------------------------------------
enablea20kbwait:                        ; wait for safe to write to 8042
        xor cx,cx
__enablea20kbwaitl0:
        jmp short $+2
        jmp short $+2
        jmp short $+2
        in al,64h                       ; read 8042 status
        test al,2                       ; buffer full?
        loopnz __enablea20kbwaitl0      ; if yes, loop
        ret

;-----------------------------------------------------------------------------
enablea20test:                          ; test for enabled A20
        mov al,[fs:0]                   ; get byte from 0:0
        mov ah,al                       ; preserve old byte
        not al                          ; modify byte
        xchg al,[gs:10h]                ; put modified byte to 0ffffh:10h
        cmp ah,[fs:0]                   ; set zero if byte at 0:0 not modified
        mov [gs:10h],al                 ; put back old byte at 0ffffh:10h
        ret                             ; return, zero if A20 enabled

        finished_a20:


        mov eax,cr0             ;Prepare for switch.
        or al,1

        lgdt [gdt]              ;Load GDT.

        mov cr0,eax             ;Switch to pmode.


        mov ax,selds            ;Set default segments.
        mov ds,ax
        mov es,ax
        mov ax,selzero
        mov fs,ax
        mov gs,ax
        mov ss,ax

        mov esp,0x200000

        jmp dword code32_sel:0  ;Jmp to pmode code.


        times ($$-$) &15 nop    ;Padding, for speed.

        stack:                  ;4k stack, should be plenty.
        times 4096 db 0         


        code32_starts:
[bits 32]

;        jmp $

        ;Here, will be a JMP code32_sel:offset created by dxedump!
