;
;     Ejemplo de entrada y salida a Modo Protejido
;           Realizado por: Daniel Lancha Garcia
;
;       ATENCION:  Solo funciona en Modo Real NO en Virtual
;                     con el EMM386 o similar se colgara
;
;  Compilar: TASM PROTETED.ASM 
;            TLINK /3 /T PROTETED.OBJ
;
;   Se supone libre unos 200Kbytes ( no reservada por MS-DOS )
;     a partir desde donde se carga el .COM


.386p


ActivarInterrupciones MACRO
        cli
        mov     dx,20h           ;Activar Interrupciones
        mov     al,11h
        out     dx,al
        mov     dx,21h
        mov     al,08h
        out     dx,al
        mov     al,04h
        out     dx,al
        mov     al,01h
        out     dx,al
        mov     al,byte ptr cs:INT_MASK
        out     dx,al
        in      al,60h
        sti        
    ENDM

DesactivarInterrupciones MACRO
        cli
        mov     dx,21h
        in      al,dx
        mov byte ptr cs:INT_MASK,al
        mov     dx,20h          ;Desactivar interrupciones
        mov     al,11h
        out     dx,al
        mov     dx,21h
        mov     al,30h
        out     dx,al
        mov     al,4
        out     dx,al
        mov     al,1
        out     dx,al
        mov     al,11111111b
        out     dx,al
        sti
     ENDM   

ActivarBitProtejido MACRO
        mov     eax,cr0     ; Activar Bit Modo Protejido
        or      eax,1
        mov     cr0,eax
     ENDM

DesactivarBitProtejido MACRO
        mov     eax,cr0     ; Desactivar Bit Modo Protejido
        and     eax,07FFFFFFEh
        mov     cr0,eax
     ENDM   

CargarGDT MACRO A
        db      66h
        lgdt FWORD PTR A   ; Carga GDT
     ENDM

CargarIDT MACRO A
        cli
        db      66h
        lidt FWORD PTR A   ; Carga IDT
        sti
     ENDM        

D_BIT         EQU 40h        ; D BIT FOR 32 BIT TYPES
EO_SEG        EQU 08h        ; EXECUTE ONLY
ER_SEG        EQU 0Ah        ; EXECUTE AND READ
EOC_SEG       EQU 0Ch        ; EXECUTE ONLY, CONFORMING
ERC_SEG       EQU 0Eh        ; EXECUTE AND READ , CONFORMING
RO_SEG        EQU 00h        ; READ ONLY , NORMAL
RW_SEG        EQU 02h        ; READ / WRITE , NORMAL
ROED_SEG      EQU 04h        ; READ ONLY , EXPAND-DOWN
RWED_SEG      EQU 06h        ; READ / WRITE , EXPAND-DOWN
ED            EQU 04h        ; EXPAND DOWN BIT
PRESENT       EQU 80h        ; SEGMENT PRESENT
DAT           EQU 10h        ; SEGMENT DATA
EXE           EQU 18h        ; SEGMENT EXECUTABLE

SELECTOR_CS   EQU GDT_CS-GDT
SELECTOR_DS   EQU GDT_DS-GDT
SELECTOR_ES   EQU GDT_ES-GDT
SELECTOR_SS   EQU GDT_SS-GDT

SE SEGMENT PARA USE16 'CODE' 

ORG 256        ; Necesario en .COM

START:
        ASSUME cs:SE,ss:SE
    ; COMPLETAR DESCRIPTOR CS,DS,SS -> BASE LOW , MED
        xor     eax,eax
        mov     ax,cs
        shl     eax,4
        mov WORD PTR cs:2[GDT_CS],ax
        mov WORD PTR cs:2[GDT_DS],ax
        mov WORD PTR cs:2[GDT_SS],ax
        shr     eax,16
        mov BYTE PTR cs:4[GDT_CS],al
        inc     al
        mov BYTE PTR cs:4[GDT_DS],al
        inc     al
        mov BYTE PTR cs:4[GDT_SS],al
    ; COPIAR DATOS en CS<<4+0x10000
        mov     ax,cs
        mov     ds,ax
        add     ax,1000h
        mov     es,ax
        mov     si,OFFSET GDT
        xor     di,di        
        mov     cx,4096
        cld
        rep movsw
    ; COMPLETAR LAS VARIABLES BASE_LIMIT
        xor     eax,eax
        mov     ax,cs
        shl     eax,4
        add     eax,10000h
        mov DWORD PTR cs:2[GDT_BASE_LIMIT],eax
        mov     ebx,FIN_GDT-GDT
        mov WORD PTR cs:[GDT_BASE_LIMIT],bx
        add     eax,ebx
        mov DWORD PTR cs:2[IDT_BASE_LIMIT],eax    
        mov     ebx,FIN_IDT-IDT
        mov WORD PTR cs:[IDT_BASE_LIMIT],bx 
;       -------
; PASAR A MODO PROTEJIDO
;       -------
        CargarGDT cs:GDT_BASE_LIMIT
        CargarIDT cs:IDT_BASE_LIMIT
        DesactivarInterrupciones
        ActivarBitProtejido
        jmp far ptr Protejido
; --------------
; MODO PROTEJIDO
; --------------
Protejido:
        call enablea20       
        mov      ax,SELECTOR_ES
        mov      ss,ax
        mov      esp,400h
        mov      ax,8*3         ; Mostrar Ok. por pantalla
        mov      es,ax          
        mov      edi,8000h      ; es:edi = 0x000b8000
        mov      ah,15+16
        mov      al,'O'
        mov word ptr es:[edi],ax
        mov      al,'k'
        mov word ptr es:2[edi],ax
        mov      al,'.'
        mov word ptr es:4[edi],ax
;      -------
; PASAR A MODO REAL
;      -------
        mov     ax,SELECTOR_DS  ; Cargar segmentos reales
        mov     ds,ax
        mov     es,ax
        mov     ss,ax
        mov     fs,ax
        mov     gs,ax        ; Cargar Idt Real
        CargarIDT ds:[OLD_IDT_BASE_LIMIT-PRINCIPIO_DATOS]
        DesactivarBitProtejido
        jmp far ptr real
; ---------
; MODO REAL
; ---------
real:
        ActivarInterrupciones
        mov     ax,cs
        mov     ss,ax
        mov     sp,0FFFFh
        mov     ax,4C00h                ;Fin
        int     21h

enablea20:                ; Habilitar la linea A20 ?
	call  enablea201
	jnz short enablea20done
	mov al,0d1h
	out 64h,al
	call  enablea201
	jnz short enablea20done
	mov al,0dfh
	out 60h,al
enablea201:
	mov ecx,20000h
enablea201l:
	jmp short $+2
	in  al,64h
	test  al,2
	loopnz  enablea201l
enablea20done:
	ret


;         \\\\\ AREA DE DATOS /////

PRINCIPIO_DATOS:
                
GDT:
                        ; NULL DESCRIPTOR
        dd        0,0        
GDT_CS:                ; CS DESCRIPTOR
        dw        0FFFFh               ; CS DESCRIPTOR ELIMIT
        dw        ?                    ; CS DESCRIPTOR BASE LOW
        db        ?                    ; CS DESCRIPTOR BASE MED
        db        ER_SEG+PRESENT+DAT   ; CS DESCRIPTOR EACCESS
        db        00h                  ; CS DESCRIPTOR E386
        db        00h                  ; CS DESCRIPTOR BASE HIGH
GDT_DS:                ; DS DESCRIPTOR ? CS<<4+0x10000
        dw        0FFFFh               ; DS DESCRIPTOR ELIMIT
        dw        ?                    ; DS DESCRIPTOR BASE LOW
        db        ?                    ; DS DESCRIPTOR BASE MED
        db        RW_SEG+PRESENT+DAT   ; DS DESCRIPTOR EACCESS
        db        D_BIT                ; DS DESCRIPTOR E386
        db        00h                  ; DS DESCRIPTOR BASE HIGH
GDT_ES:                ; ES DESCRIPTOR ? 0xB0000
        dw        0FFFFh               ; ES DESCRIPTOR ELIMIT
        dw        0000h                ; ES DESCRIPTOR BASE LOW
        db        0Bh                  ; ES DESCRIPTOR BASE MED
        db        RW_SEG+PRESENT+DAT   ; ES DESCRIPTOR EACCESS
        db        D_BIT                ; ES DESCRIPTOR E386
        db        0                    ; ES DESCRIPTOR BASE HIGH
GDT_SS:                ; SS DESCRIPTOR ? CS<<4+0x20000
        dw        0FFFFh               ; SS DESCRIPTOR ELIMIT
        dw        ?                    ; SS DESCRIPTOR BASE LOW
        db        ?                    ; SS DESCRIPTOR BASE MED
        db        RW_SEG+PRESENT+DAT   ; SS DESCRIPTOR EACCESS
        db        00h                  ; SS DESCRIPTOR E386
        db        00h                  ; SS DESCRIPTOR BASE HIGH
        
        dq        100 dup(0)
FIN_GDT:

IDT:       ; ( No se utiliza )
                        ;IDT0  
        dw        0             ;        IDT0 OFFSET LOW
        dw        0             ;        IDT0 SEGMENT SELECTOR
        db        0             ;        IDT0 DWORD COUNT
        db        0             ;        IDT0 GACCESS
        dw        0             ;        IDT0 OFFSET HIGH
                        ; Resto de IDTs
        dq        200        dup(0)
FIN_IDT:

GDT_BASE_LIMIT:       
                dw        0FFFFh        ; GDT Limite
                dd        30000h        ; GDT Base

IDT_BASE_LIMIT:       
                dw        0FFFFh        ; IDT Limte
                dd        40000h        ; IDT Base


OLD_IDT_BASE_LIMIT:        
                dw        3fffh         ; IDT real : Limite
                dd        0h            ; IDT real : Base
    
INT_MASK:
        db        ?                ; Mascara de interrupciones


SE ENDS

END START
