;
;     Ejemplo de control de tareas en Modo Protejido con paginado
;           Realizado por: Daniel Lancha Garcia
;
;       ATENCION:  Solo funciona en Modo Real NO en Virtual
;                     con el EMM386 o similar se colgara
;
;  Compilar: TASM PROTETED.ASM 
;            TLINK /3 /T PROTETED.OBJ
;
;   Se supone libre unos 200 Kbytes ( no reservada por MS-DOS )
;     a partir desde donde se carga el .COM


.386p


ActivarInterrupciones MACRO
        cli
        mov     dx,20h           ;Activar Interrupciones
        mov     al,11h
        out     dx,al
        mov     dx,21h
        mov     al,08h
        out     dx,al
        mov     al,04h
        out     dx,al
        mov     al,01h
        out     dx,al
        mov     al,byte ptr cs:INT_MASK
        out     dx,al
        in      al,60h
        sti        
    ENDM

DesactivarInterrupciones MACRO
        cli
        mov     dx,21h
        in      al,dx
        mov byte ptr cs:INT_MASK,al
        mov     dx,20h          ;Desactivar interrupciones
        mov     al,11h
        out     dx,al
        mov     dx,21h
        mov     al,30h
        out     dx,al
        mov     al,4
        out     dx,al
        mov     al,1
        out     dx,al
        mov     al,11111111b
        out     dx,al
        sti
     ENDM   

ActivarBitProtejido MACRO
        mov     eax,cr0     ; Activar Bit Modo Protejido
        or      eax,80000001h 
        mov     cr0,eax
     ENDM


DesactivarBitProtejido MACRO
        mov     eax,cr0     ; Desactivar Bit Modo Protejido
        and     eax,7FFFFFFEh        ; y Bit Paginado
        mov     cr0,eax
     ENDM   

CargarGDT MACRO A
        db      66h
        lgdt FWORD PTR A   ; Carga GDT
     ENDM

CargarIDT MACRO A
        cli
        db      66h
        lidt FWORD PTR A   ; Carga IDT
        sti
     ENDM        
     
CargarTablaEntradas MACRO A
        mov     eax,A
        mov     cr3,eax
     ENDM        

SaltoLargo MACRO Selector,Desplazamiento
        db        0EAh
        dw        Desplazamiento
        dw        Selector
   ENDM   

D_BIT         EQU 40h        ; D BIT FOR 32 BIT TYPES
EO_SEG        EQU 08h        ; EXECUTE ONLY
ER_SEG        EQU 08h        ; EXECUTE AND READ
EOC_SEG       EQU 0Ch        ; EXECUTE ONLY, CONFORMING
ERC_SEG       EQU 0Eh        ; EXECUTE AND READ , CONFORMING
RO_SEG        EQU 00h        ; READ ONLY , NORMAL
RW_SEG        EQU 02h        ; READ / WRITE , NORMAL
ROED_SEG      EQU 04h        ; READ ONLY , EXPAND-DOWN
RWED_SEG      EQU 06h        ; READ / WRITE , EXPAND-DOWN
ED            EQU 04h        ; EXPAND DOWN BIT
PRESENT       EQU 80h        ; SEGMENT PRESENT
DAT           EQU 10h        ; SEGMENT DATA
EXE           EQU 18h        ; SEGMENT EXECUTABLE
TSR           EQU 09h        ; TASK SEGMENT

SELECTOR_CS   EQU GDT_CS-GDT
SELECTOR_DS   EQU GDT_DS-GDT
SELECTOR_ES   EQU GDT_ES-GDT
SELECTOR_SS   EQU GDT_SS-GDT
SELECTOR_TSR  EQU GDT_TSR-GDT

TSS_STRUC     STRUC
  RBACKLINK        DW 0        ; 0 --00h
  RES1             DW 0        ; 1 --02h
  RESP0            DD 0        ; 2 --04h
  RSS0             DW 0        ; 3 --08h
  RES2             DW 0        ; 4 --0Ah
  RESP1            DD 0        ; 5 --0Ch
  RSS1             DW 0        ; 6 --10h
  RES3             DW 0        ; 7 --12h
  RESP2            DD 0        ; 8 --14h
  RSS2             DW 0        ; 9 --18h
  RES4             DW 0        ;10 --1Ah
  RCR3             DD 0        ;11 --1Ch
  REIP             DD 0        ;12 --20h
  REFLAGS          DD 0        ;13 --24h
  REAX             DD 0        ;14 --28h
  RECX             DD 0        ;15 --2Ch
  REDX             DD 0        ;16 --30h
  REBX             DD 0        ;17 --34h
  RESP             DD 0        ;18 --38h
  REBP             DD 0        ;19 --3Ch
  RESI             DD 0        ;20 --40h
  REDI             DD 0        ;21 --44h
  RES              DW 0        ;22 --48h
  RES5             DW 0        ;23 --4Ah
  RCS              DW 0        ;24 --4Ch
  RES6             DW 0        ;25 --4Eh
  RSS              DW 0        ;26 --50h
  RES7             DW 0        ;27 --52h
  RDS              DW 0        ;28 --54h
  RES8             DW 0        ;29 --56h
  RFS              DW 0        ;30 --58h
  RES9             DW 0        ;31 --5Ah
  RGS              DW 0        ;32 --5Ch
  RES10            DW 0        ;33 --5Eh
  RLDTR            DW 0        ;34 --60h
  RES11            DW 0        ;35 --62h
  RTBIT            DW 0        ;36 --64h
  RIOBASE          DW 0        ;37 --66h
TSS_STRUC        ENDS  

SE SEGMENT PAGE USE16 'CODE' 

ORG 256        ; Necesario en .COM

START:
        ASSUME cs:SE
    ; PONER CS EN EL PRINCIPIO DE UNA PAGINA        
        mov     ax,cs
        mov     ds,ax
        and     ax,0FF00h
        add     ax,0100h
        mov     ss,ax
        mov     esp,0FF00h
        mov     es,ax
        mov     si,0FFFFh
        mov     di,si
        mov     cx,si
        std
        rep movsb
        push    es
        mov     ax,offset inicio
        push    ax
        retf
inicio:    
    ; COMPLETAR DESCRIPTOR CS,DS,SS,TSR -> BASE LOW , MED
        xor     eax,eax
        mov     ax,cs
        shl     eax,4
        mov WORD PTR cs:2[GDT_CS],ax
        mov WORD PTR cs:2[GDT_DS],ax
        mov WORD PTR cs:2[GDT_SS],ax
        push    eax
        shr     eax,16
        mov BYTE PTR cs:4[GDT_CS],al
        inc     al
        mov BYTE PTR cs:4[GDT_DS],al
        inc     al
        mov BYTE PTR cs:4[GDT_SS],al
        pop     eax
        add     eax,14000h
        mov WORD PTR cs:2[GDT_TSR],ax
        shr     eax,16
        mov BYTE PTR cs:4[GDT_TSR],al
    ; COPIAR DATOS en CS<<4+0x10000
        mov     ax,cs
        mov     ds,ax
        add     ax,1000h
        mov     es,ax
        mov     si,OFFSET GDT
        xor     di,di        
        mov     cx,(4096/2)*5
        cld
        rep movsw
    ; COMPLETAR LAS VARIABLES BASE_LIMIT
        xor     eax,eax
        mov     ax,es
        shl     eax,4
        mov     ebx,4096
        mov DWORD PTR es:2[GDT_BASE_LIMIT],eax
        mov WORD PTR es:[GDT_BASE_LIMIT],bx
        add     eax,ebx
        mov DWORD PTR es:2[IDT_BASE_LIMIT],eax    
        mov WORD PTR es:[IDT_BASE_LIMIT],bx 
    ; COMPLETAR TABLAS DE ENTRADAS Y TABLA DE PAGINAS
        xor      eax,eax
        mov      ax,es
        shl      eax,4
        mov      edi,4096*3
        add      eax,edi
        add      eax,3
        mov      es:[4096*2],eax
        mov      eax,3
        mov      ecx,1024
 otra_pagina:
        stosd
        add      eax,4096
        loop     otra_pagina                
;       -------
; PASAR A MODO PROTEJIDO
;       -------
        mov      ax,cs        ; Completar salto largo de vuelta
        mov word ptr cs:3[Segmento_CS],ax ; con CS real
        xor      eax,eax
        mov      ax,es
        shl      eax,4
        add      eax,4096*2
        CargarTablaEntradas eax
        CargarGDT es:GDT_BASE_LIMIT
        CargarIDT es:IDT_BASE_LIMIT
        DesactivarInterrupciones
        ActivarBitProtejido
        SaltoLargo SELECTOR_CS,Protejido
; --------------
; MODO PROTEJIDO
; --------------
Protejido:
        call enablea20       
        mov      ax,SELECTOR_TSR
        ltr      ax
        SaltoLargo SELECTOR_CS,Entrada_TareaPadre
Entrada_TareaPadre:
        mov      ax,SELECTOR_ES
        mov      ss,ax
        mov      esp,400h
        mov      ax,8*3         ; Mostrar Ok. por pantalla
        mov      es,ax          
        mov      edi,8000h      ; es:edi = 0x000b8000
        mov      ah,15+16
        mov      al,'O'
        mov word ptr es:[edi],ax
        mov      al,'k'
        mov word ptr es:2[edi],ax
        mov      al,'.'
        mov word ptr es:4[edi],ax
        
;      -------
; PASAR A MODO REAL
;      -------
        mov     ax,SELECTOR_DS  ; Cargar segmentos reales
        mov     ds,ax
        mov     es,ax
        mov     ss,ax
        mov     fs,ax
        mov     gs,ax        ; Cargar Idt Real
        CargarIDT ds:[OLD_IDT_BASE_LIMIT-PRINCIPIO_DATOS]
        DesactivarBitProtejido
Segmento_CS:                ; Salto largo de vuelta
        SaltoLargo 0,real        ; a completar
; ---------
; MODO REAL
; ---------
real:
        ActivarInterrupciones
        mov     ax,cs
        mov     ss,ax
        mov     sp,0FFFFh
        mov     ax,4C00h                ;Fin
        int     21h

enablea20:                ; Habilitar la linea A20 ?
	call  enablea201
	jnz short enablea20done
	mov al,0d1h
	out 64h,al
	call  enablea201
	jnz short enablea20done
	mov al,0dfh
	out 60h,al
enablea201:
	mov ecx,20000h
enablea201l:
	jmp short $+2
	in  al,64h
	test  al,2
	loopnz  enablea201l
enablea20done:
	ret


;         \\\\\ AREA DE DATOS /////

PRINCIPIO_DATOS:
                
GDT:         ; PAGINA 0
                        ; NULL DESCRIPTOR
        dd        0,0        
GDT_CS:                ; CS DESCRIPTOR
        dw        0FFFFh               ; CS DESCRIPTOR ELIMIT
        dw        ?                    ; CS DESCRIPTOR BASE LOW
        db        ?                    ; CS DESCRIPTOR BASE MED
        db        ER_SEG+PRESENT+DAT   ; CS DESCRIPTOR EACCESS
        db        00h                  ; CS DESCRIPTOR E386
        db        00h                  ; CS DESCRIPTOR BASE HIGH
GDT_DS:                ; DS DESCRIPTOR ? CS<<4+0x10000
        dw        0FFFFh               ; DS DESCRIPTOR ELIMIT
        dw        ?                    ; DS DESCRIPTOR BASE LOW
        db        ?                    ; DS DESCRIPTOR BASE MED
        db        RW_SEG+PRESENT+DAT   ; DS DESCRIPTOR EACCESS
        db        D_BIT                ; DS DESCRIPTOR E386
        db        00h                  ; DS DESCRIPTOR BASE HIGH
GDT_ES:                ; ES DESCRIPTOR ? 0xB0000
        dw        0FFFFh               ; ES DESCRIPTOR ELIMIT
        dw        0000h                ; ES DESCRIPTOR BASE LOW
        db        0Bh                  ; ES DESCRIPTOR BASE MED
        db        RW_SEG+PRESENT+DAT   ; ES DESCRIPTOR EACCESS
        db        D_BIT                ; ES DESCRIPTOR E386
        db        0                    ; ES DESCRIPTOR BASE HIGH
GDT_SS:                ; SS DESCRIPTOR ? CS<<4+0x20000
        dw        0FFFFh               ; SS DESCRIPTOR ELIMIT
        dw        ?                    ; SS DESCRIPTOR BASE LOW
        db        ?                    ; SS DESCRIPTOR BASE MED
        db        RW_SEG+PRESENT+DAT   ; SS DESCRIPTOR EACCESS
        db        00h                  ; SS DESCRIPTOR E386
        db        00h                  ; SS DESCRIPTOR BASE HIGH
GDT_TSR:               ; TSR DESCRIPTOR        
        dw        00068h               ; TSR DESCRIPTOR ELIMIT
        dw        ?                    ; TSR DESCRIPTOR BASE LOW
        db        ?                    ; TSR DESCRIPTOR BASE MED
        db        TSR+PRESENT          ; TSR DESCRIPTOR EACCESS
        db        00h                  ; TSR DESCRIPTOR E386
        db        00h                  ; TSR DESCRIPTOR BASE HIGH
     
        dq        506 dup(0) ; (506+6)*8=4096=Pagina
FIN_GDT:

IDT:       ; PAGINA 1
                        ;IDT0  
        dw        0             ;        IDT0 OFFSET LOW
        dw        0             ;        IDT0 SEGMENT SELECTOR
        db        0             ;        IDT0 DWORD COUNT
        db        0             ;        IDT0 GACCESS
        dw        0             ;        IDT0 OFFSET HIGH
                        ; Resto de IDTs
        dq        511 dup(0) ; (511+1)*8=4096=Pagina
FIN_IDT:

TABLA_ENTRADAS:     ; PAGINA 2
        dd       1024 dup(0)

TABLA_PAGINAS:      ; PAGINA 3
        dd       1024 dup(0)

TSS:                ; PAGINA 4
        TSS_STRUC <,,,,,,,,,,\
                ,,OFFSET Entrada_TareaPadre,1202h,,,,,\
                4095,,,,,\
                ,SELECTOR_CS,,SELECTOR_SS,\
                ,SELECTOR_DS,,,,,,,,,>
                
GDT_BASE_LIMIT:       
                dw        0FFFFh        ; GDT Limite
                dd        30000h        ; GDT Base

IDT_BASE_LIMIT:       
                dw        0FFFFh        ; IDT Limte
                dd        40000h        ; IDT Base


OLD_IDT_BASE_LIMIT:        
                dw        3fffh         ; IDT real : Limite
                dd        0h            ; IDT real : Base
    
INT_MASK:
        db        ?                ; Mascara de interrupciones


SE ENDS

END START
