#ifndef _SETJMP_H_
#define _SETJMP_H_

typedef struct {
	ulong eip;
	ulong edi;
	ulong esi;
	ulong ebp;
	ulong esp;
	ulong ebx;
	ulong edx;
	ulong ecx;
	ulong eax;
} jmp_buf[1];

/*
 * setjmp()
 *	Save context, returning 0
 */
inline static int
setjmp(jmp_buf regs)
{
	register int retcode;

	__asm__ __volatile__ (
		"movl $1f,(%%edi)\n\t"
		"movl %%esi,8(%%edi)\n\t"
		"movl %%esp,%%eax\n\t"
		"movl %%ebp,12(%%edi)\n\t"
		"subl $4,%%eax\n\t"
		"movl %%eax,16(%%edi)\n\t"
		"xorl %%eax,%%eax\n\t"
		"movl %%ebx,20(%%edi)\n\t"
		"movl %%edx,24(%%edi)\n\t"
		"movl %%ecx,28(%%edi)\n"
		"1:\n\t"
		: "=a" (retcode)
		: "D" (regs));
	return(retcode);
}

/*
 * longjmp()
 *	Restore context, returning a specified result
 */
inline static void
longjmp(jmp_buf regs, int retval)
{
	__asm__ __volatile__ (
		"movl 16(%%edi),%%esp\n\t"
		"movl 12(%%edi),%%ebp\n\t"
		"movl 8(%%edi),%%esi\n\t"
		"movl (%%edi),%%edx\n\t"
		"movl %%edx,(%%esp)\n\t"
		"movl 20(%%edi),%%ebx\n\t"
		"movl 24(%%edi),%%edx\n\t"
		"movl 28(%%edi),%%ecx\n\t"
		"ret\n\t"
		: /* No output */
		: "D" (regs), "a" (retval));
}

#endif /* _SETJMP_H_ */
