.386p

  INCLUDE ..\EXTENSOR.INC

  PUBLIC Ext_CopiarMemoria_,Ext_BorrarMemoria_,Ext_RellenarMemoria_
  PUBLIC Ext_LongitudCadena_,Ext_CrearAcceso_,Ext_HacerSelector_
  PUBLIC Ext_CrearSelector_,Ext_DestruirSelector_,Ext_ReservarMemoriaDPMI_
  PUBLIC Ext_LiberarMemoriaDPMI_,Ext_HacerPuntero_,Ext_Segmento_
  PUBLIC Ext_Desplazamiento_,FIN_PROCS32,INICIO_PROCS32

_TEXT SEGMENT PARA PUBLIC USE32 'CODE'

        ASSUME CS:_TEXT

 INICIO_PROCS32 LABEL DWORD

Ext_CopiarMemoria_ PROC FAR
       push    ebp
       mov     ebp,esp
       pushad
       push    ds
       push    es
       mov     esi,eax
       mov     ds,dx
       mov     edi,ebx
       mov     es,cx
       mov     ecx,ss:[ebp+12]
       cld
       shr     ecx,1
       jnc     Copy_1
       movsb
 Copy_1:
       shr     ecx,1
       jnc     Copy_2
       movsw
 Copy_2:
       rep     movsd        
       pop     es
       pop     ds
       popad
       pop     ebp
       retf    4
Ext_CopiarMemoria_ ENDP

Ext_BorrarMemoria_ PROC FAR
       pushad
       push    es
       mov     edi,eax
       mov     es,dx
       mov     ecx,ebx
       xor     eax,eax
       cld
       shr     ecx,1
       jnc     Clear_1
       stosb
 Clear_1:
       shr     ecx,1
       jnc     Clear_2
       stosw
 Clear_2:
       rep     stosd        
       pop     es
       popad
       retf
Ext_BorrarMemoria_ ENDP

Ext_RellenarMemoria_ PROC FAR
       pushad
       push    es
       mov     edi,eax
       mov     es,dx
       mov     ah,cl
       mov     al,cl
       rol     eax,16
       mov     ah,cl
       mov     al,cl
       mov     ecx,ebx
       cld
       shr     ecx,1
       jnc     Fill_1
       stosb
 Fill_1:
       shr     ecx,1
       jnc     Fill_2
       stosw
 Fill_2:
       rep     stosd
       pop     es
       popad
       retf
Ext_RellenarMemoria_ ENDP

Ext_LongitudCadena_ PROC FAR
        push    ds
        push    edi
        mov     ds,dx
        mov     edi,eax
        xor     eax,eax
 Ext_strlen_otra:
        test BYTE PTR ds:[edi+eax],0FFh
        jz      Ext_strlen_salida
        inc     eax
        jmp Ext_strlen_otra
 Ext_strlen_salida:
        pop     edi
        pop     ds
        retf
Ext_LongitudCadena_ ENDP

Ext_CrearAcceso_ PROC FAR    ;ushort Ext_CrearAcceso(tipo,dpl,defecto,granu)
        push    edx
        push    ebx
        push    ecx
        and     eax,1fh
        and     edx,3
        rol     edx,5
        add     eax,edx
        or      ebx,ebx
        jz      Ext_CrearAcceso_NoDefecto
        add     eax,4000h
 Ext_CrearAcceso_NoDefecto:
        or      ecx,ecx
        jz      Ext_CrearAcceso_NoGranularidad
        add     eax,8000h
 Ext_CrearAcceso_NoGranularidad:
        add     eax,1080h
        pop     ecx
        pop     ebx
        pop     edx
        retf
Ext_CrearAcceso_ ENDP

Ext_HacerSelector_ PROC FAR  ; CX= Selector , lo demas como Ext_CrearSelector

        push        EBX        ; Acceso
        push        EDX        ; Limite
        push        EAX        ; Base
        mov         AX,CX
Ext_HacerSelector_Salto:
        pop         DX
        pop         CX
        push        AX
        mov         BX,AX
        mov         AX,7
        int         31h        ; Poner Base
        or          AX,AX
        js          Ext_HacerSelector_Error2
        
        pop         BX
        pop         DX
        pop         CX
        push        BX
        mov         AX,8
        int         31h        ; Poner Limite
        or          AX,AX
        js          Ext_HacerSelector_Error3
        
        pop         BX
        pop         ECX
        push        BX
        mov         AX,9
        int         31h        ; Poner Acceso
        or          AX,AX
        js          Ext_HacerSelector_Error4
        xor         EAX,EAX
        pop         AX         ; Devuelve el selector
        retf                   ; Retorno sin error        
        
 Ext_HacerSelector_Error2:
        pop         BX
        mov         EAX,1
        int         31h        ; Liberar descriptor
        mov         EAX,-2        
        retf        8          ; Retorno con error -2

 Ext_HacerSelector_Error3:
        pop         BX
        mov         EAX,1
        int         31h        ; Liberar descriptor
        mov         EAX,-3        
        retf        4          ; Retorno con error -3

 Ext_HacerSelector_Error4:
        pop         BX
        mov         EAX,1
        int         31h        ; Liberar descriptor
        mov         EAX,-4        
        retf                   ; Retorno con error -4


Ext_HacerSelector_ ENDP

Ext_CrearSelector_ PROC FAR
        
        push        EBX        ; Acceso
        push        EDX        ; Limite
        push        EAX        ; Base
        
        xor         EAX,EAX
        mov         ECX,1
        int         31h        ; Crea 1 Descriptor
        or          AX,AX
        jns         Ext_HacerSelector_Salto
        mov         EAX,-1
        retf        12         ; Retorno con error -1
Ext_CrearSelector_ ENDP

Ext_DestruirSelector_ PROC FAR
        push       ebx
        mov        EBX,EAX
        mov        EAX,1
        int        31h         ; Liberar descriptor
        or         AX,AX
        js         DestruirSelector_Error
        xor        EAX,EAX     ; Retorno con exito
        retf

 DestruirSelector_Error:
        mov        EAX,-1      ; Retorno con error
        pop        ebx
        retf
Ext_DestruirSelector_ ENDP

Ext_ReservarMemoriaDPMI_ PROC FAR
        push        DS
        push        edx
        push        ecx
        push        ebx
        mov         DS,DX
        mov         EDX,EAX
        mov         CX,DS:[EDX]
        mov         BX,DS:2[EDX]
        push        EDX
        mov         AX,0501h
        int         31h
        or          AX,AX
        js          ReservarMemoria_Error
        pop         EDX
        mov         DS:4[EDX],CX
        mov         DS:6[EDX],BX
        mov         DS:8[EDX],DI
        mov         DS:10[EDX],SI
        pop         ebx
        pop         ecx
        pop         edx
        pop         DS
        xor         EAX,EAX
        retf
ReservarMemoria_Error:
        pop         EDX
        pop         ebx
        pop         ecx
        pop         edx
        pop         DS
        mov         EAX,-1
        retf
Ext_ReservarMemoriaDPMI_ ENDP

Ext_LiberarMemoriaDPMI_ PROC FAR
        push        DS
        push        edx
        push        edi
        push        esi
        mov         DS,DX
        mov         EDX,EAX
        mov         DI,DS:8[EDX]
        mov         SI,DS:10[EDX]
        mov         AX,0502h
        int         31h
        or          AX,AX
        js          LiberarMemoria_Error
        xor         EAX,EAX
        pop         esi
        pop         edi
        pop         edx
        pop         DS
        retf
LiberarMemoria_Error:
        mov         EAX,-1
        pop         esi
        pop         edi
        pop         edx
        pop         DS
        retf
Ext_LiberarMemoriaDPMI_ ENDP

Ext_HacerPuntero_ PROC FAR
        push        DS
        mov         DS,CX
        mov         DS:[EBX],EDX
        mov         DS:4[EBX],AX
        pop         DS
        retf
Ext_HacerPuntero_ ENDP

Ext_Segmento_ PROC FAR
        xor         EAX,EAX
        mov         AX,DX
        retf
Ext_Segmento_ ENDP

Ext_Desplazamiento_ PROC FAR
        retf
Ext_Desplazamiento_ ENDP


 FIN_PROCS32 LABEL DWORD

_TEXT ENDS

END

