.386p

  INCLUDE ..\EXTENSOR.INC

    PUBLIC INICIO_GDT,SELECTOR_CS,GDT_CS,SELECTOR_GDT,GDT_GDT
    PUBLIC SELECTOR_REAL_DS,GDT_REAL_DS,SELECTOR_DS,GDT_DS
    PUBLIC SELECTOR_VIDEO,GDT_VIDEO,SELECTOR_SS,GDT_SS
    PUBLIC SELECTOR_IDT,GDT_IDT,SELECTOR_DMA,GDT_DMA,SELECTOR_CS32,GDT_CS32
    PUBLIC SELECTOR_MEMBASE,GDT_MEMBASE,SELECTOR_DPMI,GDT_DPMI
    PUBLIC SELECTOR_DUMMY_TSS,GDT_DUMMY_TSS,SELECTOR_TSS32,GDT_TSS32
    PUBLIC SELECTOR_START32_TSS,GDT_START32_TSS,SELECTOR_LDT,GDT_LDT
    PUBLIC SELECTOR_LDT32,GDT_LDT32,SELECTOR_PILA_TASK,GDT_PILA_TASK
    PUBLIC SELECTOR_TASK_TSS,GDT_TASK_TSS,SELECTOR_TASK,GDT_TASK
    PUBLIC SELECTOR_PILA_INT,GDT_PILA_INT,SELECTOR_TIMER_TSS,GDT_TIMER_TSS
    PUBLIC SELECTOR_TIMER,GDT_TIMER,SELECTOR_CAMBIO,GDT_CAMBIO
    PUBLIC SELECTORES_SISTEMA,FIN_GDT

GDT SEGMENT USE16
INICIO_GDT        LABEL        DWORD
        dd        00h,00h                                   ; NULL DESCRIPTOR

SELECTOR_CS        EQU       $-INICIO_GDT
GDT_CS  stGDT <0FFFFh,?,?,EL_SEG+PRESENT+SEG_DESC,00h,00h>   ; CS DESCRIPTOR

SELECTOR_GDT       EQU       $-INICIO_GDT
GDT_GDT stGDT <?,?,?,LE_SEG+PRESENT+SEG_DESC,00h,00h>   ; GDT DESCRIPTOR

SELECTOR_REAL_DS   EQU       $-INICIO_GDT
GDT_REAL_DS  stGDT <0FFFFh,?,?,LE_SEG+PRESENT+SEG_DESC,00h,00h>; DS REAL DESC.

SELECTOR_DS        EQU       $-INICIO_GDT
GDT_DS  stGDT <?,?,?,LE_SEG+PRESENT+SEG_DESC,D_BIT+G_BIT,00h> ; DS DESCRIPTOR

SELECTOR_VIDEO        EQU       $-INICIO_GDT
GDT_VIDEO  stGDT <20h,0000h,0Ah,LE_SEG+PRESENT+SEG_DESC,G_BIT,00h>; VIDEO DESC

SELECTOR_SS        EQU       $-INICIO_GDT
GDT_SS  stGDT <?,?,?,LE_SEG+PRESENT+SEG_DESC,D_BIT,00h>      ; SS DESCRIPTOR

SELECTOR_IDT       EQU       $-INICIO_GDT
GDT_IDT stGDT <?,?,?,LE_SEG+PRESENT+SEG_DESC,00h,00h>   ; IDT DESCRIPTOR

SELECTOR_DMA      EQU       $-INICIO_GDT
GDT_DMA stGDT <0FFFFh,0000h,09h,LE_SEG+PRESENT+SEG_DESC,00h,00h>; DMA PAGE

SELECTOR_CS32      EQU       $-INICIO_GDT
GDT_CS32 stGDT <?,?,?,EL_SEG+PRESENT+SEG_DESC,D_BIT,00h>     ; CODE32 DESC

SELECTOR_MEMBASE   EQU       $-INICIO_GDT
GDT_MEMBASE stGDT <100h,0000h,00h,LE_SEG+PRESENT+SEG_DESC,G_BIT,00h>

SELECTOR_DPMI      EQU       $-INICIO_GDT
GDT_DPMI stGDT <LONG_TABLA_MEM*8,?,?,LE_SEG+PRESENT+SEG_DESC,00h,00h>

SELECTOR_DUMMY_TSS EQU       $-INICIO_GDT
GDT_DUMMY_TSS stGDT <6Bh,?,?,PRESENT+TSS_AVAIL_386,D_BIT,00h>

SELECTOR_START32_TSS EQU     $-INICIO_GDT
GDT_START32_TSS stGDT <6Bh,?,?,PRESENT+TSS_AVAIL_386,D_BIT,00h>

SELECTOR_TSS32  EQU     $-INICIO_GDT
GDT_TSS32 stGDT <6Bh,?,?,LE_SEG+PRESENT+SEG_DESC,D_BIT,00h>

SELECTOR_LDT    EQU     $-INICIO_GDT
GDT_LDT stGDT <LONG_LDT*8,?,?,PRESENT+LDT_DESC,D_BIT,00h>

SELECTOR_LDT32  EQU     $-INICIO_GDT
GDT_LDT32 stGDT <LONG_LDT*8,?,?,LE_SEG+PRESENT+SEG_DESC,D_BIT,00h>

SELECTOR_PILA_TASK EQU        $-INICIO_GDT
GDT_PILA_TASK stGDT <?,?,?,LE_SEG+PRESENT+SEG_DESC,D_BIT,00h>

SELECTOR_TASK_TSS EQU       $-INICIO_GDT
GDT_TASK_TSS stGDT <6Bh,?,?,PRESENT+TSS_AVAIL_386,D_BIT,00h>

SELECTOR_TASK EQU      $-INICIO_GDT
GDT_TASK stGDT <6Bh,?,?,PRESENT+LE_SEG+SEG_DESC,D_BIT,00h>

SELECTOR_PILA_INT EQU        $-INICIO_GDT
GDT_PILA_INT stGDT <?,?,?,LE_SEG+PRESENT+SEG_DESC,D_BIT,00h>

SELECTOR_TIMER_TSS EQU       $-INICIO_GDT
GDT_TIMER_TSS stGDT <6Bh,?,?,PRESENT+TSS_AVAIL_386,D_BIT,00h>

SELECTOR_TIMER EQU      $-INICIO_GDT
GDT_TIMER stGDT <6Bh,?,?,PRESENT+LE_SEG+SEG_DESC,D_BIT,00h>

SELECTOR_CAMBIO EQU     $-INICIO_GDT
GDT_CAMBIO stGDT <LONGITUD_CAMBIO*2,?,?,PRESENT+LE_SEG+SEG_DESC,D_BIT,00h>

SELECTORES_SISTEMA EQU       $-INICIO_GDT

        dq   MAX_SEL-(SELECTORES_SISTEMA/8) dup (0)        ; Resto de GDT

FIN_GDT           LABEL        DWORD
GDT ENDS

END
