;
;    Extensor de modo real a modo protejido para usar con Watcom C/C++
;          Los ejecutables se pueden utilizar sin MS-DOS
;
;              Realizado por Daniel Lancha Garcia
;

.386p

 INCLUDE EXTENSOR.INC

   
   EXTRN INT_MASK:BYTE,INT2_MASK:BYTE,SELECTOR_CS:ABS,INICIO_DATOS:BYTE
   EXTRN GDT_BL:FWORD,IDT_BL:FWORD,OLD_IDT_BL:FWORD
   EXTRN SELECTOR_DUMMY_TSS:ABS,SELECTOR_START32_TSS:ABS,SELECTOR_REAL_DS:ABS
   EXTRN GuardarDSP:PROC,ConseguirLEDS:PROC,ConseguirModoVideo:PROC
   EXTRN MSDOS:PROC,Verifica_CPU:PROC,ConseguirMemoria:PROC
   EXTRN IniciaPaginado:PROC,CompletarDescriptores:PROC,FIN:PROC

   PUBLIC INICIO_EXTENSOR,Inicio,RetornoReal,FIN_EXTENSOR
;   PUBLIC INICIO_PILA,FIN_PILA


Pila SEGMENT  USE16 PARA STACK 'STACK'
;INICIO_PILA LABEL DWORD
        db        LONGITUD_PILA_REAL dup('PILA')
;FIN_PILA LABEL DWORD
Pila ENDS


        ASSUME CS:Codigo,SS:Pila

Codigo SEGMENT USE16 PUBLIC 'CODIGO'

INICIO_EXTENSOR LABEL WORD

Inicio PROC
        call    GuardarDSP          ; Inicia DS y guarda DSP
        call    ConseguirLEDs       ; Consigue los LEDs del teclado
        call    ConseguirModoVideo  ; Modo de video original
        call    MSDOS               ; Detectar MSDOS y rehacer DSP
        call    Verifica_CPU        ; Verificar si la CPU y su modo
        call    ConseguirMemoria    ; Abre A20 y consigue memoria libre
        call    IniciaPaginado      ; Inicia paginas
        call    CompletarDescriptores ; Base y Limite de los descriptores
  ; Pasar a modo protejido
        CargarGDT GDT_BL            ; Cargar GDT del extensor
        cli                         ; Desactivar interrupciones
        CargarIDT IDT_BL            ; Cargar IDT del extensor
        IRQs_Protejido PICA,INT_MASK,40h       ; Poner IRQ's protejido
;        IRQs_Protejido PICB,INT2_MASK,50h
        ActivarBitProtejido         ; Activar modo protejido
        Salto16_16  SELECTOR_CS,Protejido ; Salto FAR para cargar CS protejido
  ; Ya en modo protejido
Protejido:
        mov        ax,offset SELECTOR_DUMMY_TSS
        ltr        ax               ; Cargar una tarea nula
        Salto16_TSS SELECTOR_START32_TSS ; Saltar a la tarea principal
 ; Pasar a Modo Real
RetornoReal:
        mov     ax,offset SELECTOR_REAL_DS  ; Poner DS correcto
        mov     ds,ax
        cli                        ; Desactivar Interrupciones
        CargarIDT OLD_IDT_BL       ; Cargar antigua IDT 
        mov     ax,ds           ; Sementos con limite 0xFFFFh -> Modo Real
        mov     es,ax             
        mov     ss,ax
        mov     fs,ax
        mov     gs,ax
        DesactivarBitProtejido     ; Pasar a modo real
        Salto16_16 Codigo,Real     ; Salto FAR para cargar CS real
  ; Ya en modo Real
Real:
        cli
        mov     ax,Pila           ; Iniciar Registros
        mov     ss,ax
        mov     sp,LONGITUD_PILA_REAL * 4
        mov     ax,seg INICIO_DATOS
        mov     ds,ax
        IRQs_Real PICA,INT_MASK,08h   ; Activar IRQs 0-7
;        IRQs_Real PICB,INT2_MASK,70h  ; Activar IRQs 8-15
        sti
        jmp     Fin              ; Salir del Extensor
Inicio ENDP

FIN_EXTENSOR LABEL DWORD

Codigo ENDS        

END Inicio
