#include <extensor.h>
#include "zeus.h"

/***************************************************************************
			IMPLEMENTACION DE LA CLASE TAREA BASICA
***************************************************************************/
Task::Task(void *inicio, char name[], uint pila, uint ldt, uchar dpl)
{
	tarea.entrada=inicio;		// Punto de entrada de la tarea
	tarea.longitud_pila=pila;	// Pues lo que pone
	tarea.longitud_LDT=ldt;		// Pues eso
	tarea.dpl=dpl;				// Privilegios de la tarea
	if( Ext_NewTask((Ext_Task far*)&tarea) == 0 )   // Reservar memoria y selectores
		TRACE("ERROR AL INICIALIZAR LA TAREA",1,15);
	tid  = tarea.ID;			// Guarda el valor del selector TSS en el tid
	tpid = Ext_TASK;			// Guarda el selector TSS del padre en el tpid
	tipo = 0;
	nombre=Ext_strdup(name);

	Me = new cMessage(inicio);
	Mr = new cMessage(inicio);
	MB = new cMessageBox(inicio);
};

Task::~Task()
{
	Ext_FreeTask(tarea.ID);		// Liberar memoria y selectores
	delete(nombre);
	delete(MB);
	delete(Me);
	delete(Mr);
};

void Task::setState(ushort t)
{
	tarea.TSS->bits=t;          	// Modifica los bits activo, terminado, etc.
};

void Task::BitMsg(ushort m)     // Modifica el bit de mensaje.
{
	if(m==1)
		tarea.TSS->bits|=0x04;  // Pone el bit a 1
	else if(m==0)
		tarea.TSS->bits&=0xFFFB;
};

void Task::Activar()
{
	tarea.TSS->bits&=0xfffe;        // Activa la tarea.
};

void Task::Desactivar()
{
	tarea.TSS->bits|=0x1;          	// Desactiva la tarea.
};

void Task::setCount(ushort c)
{
	tarea.TSS->countdown=c;		// Devuelve el numero de cuantos de ejecucion
};

ushort Task::getState(void)
{
	return tarea.TSS->bits;		// Devuelve los bits activo, terminado, etc.
};

ushort Task::BitMsg()
{
	return (tarea.TSS->bits & 0x04);	// Devuelve el bit mensaje
};

ushort Task::Terminada(void)
{
	return (tarea.TSS->bits & 0x0002);	// Mascara que devuelve el bit terminado
};

ushort Task::getTid(void)
{
	return tid;				// Devuelve el selector de la tarea (TSS o tid)
};
ushort Task::getCount(void)
{
	return tarea.TSS->countdown;				// Devuelve el tamao de cuanto de ejecucion
};
ushort Task::getStack(void)
{
	return tarea.longitud_pila;				// Devuelve el tamao de la pila
};

ushort Task::getTpid(void)
{
	return tpid;			// Devuelve selector tarea padre (o tpid)
};

void* Task::Inicio(void)
{
	return tarea.entrada;	// Devuelve selector tarea padre (o tpid)
};

void Task::exit()
{
	tarea.TSS->bits|=0x2;
	Ext_END_TASKS++;
	Ext_NextTask(1);
};

char * Task::Nombre()
{
	return nombre;			// Devuelve el nombre de la tarea
};


/***************************************************************************
			IMPLEMENTACION DE LA CLASE GESTOR DE TECLADO
***************************************************************************/
Teclado::Teclado()
{
	actual=NULL;
};

void Teclado::NextFoco()
{
	actual->tarea->ON=0;            // Se desactiva el foco actual
	actual=actual->sig;		// Tarea actual con el foco igual a la siguiente
	actual->tarea->ON=1;			// Se activa el nuevo foco
	actual->tarea->on=1;
	Permisos();
	actual->tarea->volcar_pantalla();
};

void Teclado::Permisos()
{
	struct LBTask *t;
	t=actual;
	while(t->sig!=actual)
	{
		t=t->sig;
		if((t->tarea->xmin > actual->tarea->xmax) ||
		   (t->tarea->xmax < actual->tarea->xmin))
			{
				t->tarea->on=1;		// Puede escribir pues no solapa al foco
				t->tarea->volcar_pantalla();
			}
		else
		if((t->tarea->ymin > actual->tarea->ymax) ||
		   (t->tarea->ymax < actual->tarea->ymin) )
			{
				t->tarea->on=1;		// Puede escribir pues no solapa al foco
				t->tarea->volcar_pantalla();
			}
	}
}

void Teclado::AddFoco(BTask *f)
{
	struct LBTask *nueva;		// Crea un nuevo nodo de la lista de focos
	nueva=(LBTask *)Ext_malloc(sizeof(LBTask));	// Reserva memoria para el nodo
	nueva->tarea=f;
	if(actual==NULL)			// Si es el primer foco...
	{
		nueva->sig=nueva;		// ...la tarea siguiente es ella misma
		ultimo=nueva;
		primero=nueva;
		actual=nueva;
		actual->tarea->on=1;		// permite escribir en pantalla
		actual->tarea->ON=1;		// activa el foco
	}else{
		nueva->sig=ultimo;
		ultimo=nueva;       	// Pone el nuevo nodo al final de la lista
		primero->sig=nueva;
		Permisos();
	}
};

void Teclado::DelFoco(BTask *f)
{
	struct LBTask *temp,*ant;   	// Temporales para recorrer la lista
	temp=ant=ultimo;
	if(primero==ultimo)	actual = NULL;	// Se borran todos los focos
	else{
		while(temp->tarea!=f)	// Mientras no encuentre la tarea en la lista
		{
			ant=temp;
			temp=temp->sig; 	// recorre la lista
		}
		if(temp==ant){
			primero->sig=ultimo->sig;  // Se borra el primer nodo de la lista
			ultimo=ultimo->sig;
		}else{
			ant->sig=temp->sig;		// Se actualiza la lista
			if(temp==primero) primero=ant;
		}
		if(temp==actual)    // Si se borra el foco activo se
		{
			actual=primero; // activa el primero de la lista
			actual->tarea->ON=1;	// y se le permite escritura en video
			Permisos();
			actual->tarea->volcar_pantalla();
		}
	}
	Ext_free(temp);			// Se libera la memoria reservada para el nodo
};

char Teclado::Dispatch()
{
 uchar c=0;
 if (Ext_keypressed())		// Si se ha pulsado alguna tecla
 {
	switch(c=Ext_getch())		// Miramos que tecla es:
	{
	case 0:					// Si es una tecla especial:
		if(Ext_KEYBOARD_KEY[0x38])	// Si se esta pulsando ALT
		{
			switch(Ext_getch())	// Mira que tecla se pulso ademas
			{
			case 15:		// TAB
				this->NextFoco();
				break;
			}
		}
		break;
   case 27:
	 return 1;				// Sale del planificador al pulsar ESC
   default:
	 if(actual!=NULL){
		actual->tarea->apila((char)c);  // La mete en el buffer.
		if(actual->tarea->BitMsg()==0)	// Si no espera un mensaje...
			actual->tarea->Activar();	// ...activa la tarea
		}
  }
 }
 return 0;	// continua con el planificador
};

/***************************************************************************
			IMPLEMENTACION DE LA CLASE BUFFER DE TECLADO
***************************************************************************/

BufferTeclado::BufferTeclado(void)
{
	inicio=fin=511;		// Inicio de la pila
	pos=-1;
};

BufferTeclado::~BufferTeclado(void)
{
};

void BufferTeclado::apila(char c)
{
 pila[fin]=c;
 if(fin==0)fin=511;		// Fin igual al inicio de la pila
 else fin--;
};

char BufferTeclado::desapila(void)
{
   if (inicio==fin) return 0;
   if(inicio==0)
   {
	inicio=511;
	return pila[0];
   }
   else
   {
	inicio--;
	return pila[inicio+1];
   }
};


/***************************************************************************
		IMPLEMENTACION DE LA CLASE BUFFER DE PANTALLA
***************************************************************************/
BufferPantalla::BufferPantalla(uchar Xmin, uchar Ymin, uchar Xmax, uchar Ymax)
{
	xmin=Xmin;	xmax=Xmax;
	ymin=Ymin;	ymax=Ymax;
	NR_COL = (xmax-xmin) + 1;
	NR_LIN = (ymax-ymin) + 1;
	TAM = NR_COL * NR_LIN;
	pantalla = (ushort *) Ext_malloc( TAM*sizeof(ushort));
	x=y=0;					// Posiciones del cursor iniciales
	on=0;   // por defecto no puede escribir
	ON=0;	// por defecto no tiene el foco
	memvideo=((ushort far *)Ext_MemoriaVideo)+0x18000/2;
	textatrib(AMARILLO+(AZUL<<4));
	cargar_pantalla();
};

BufferPantalla::~BufferPantalla()
{
	Ext_free(pantalla);		// Libera la memoria reservada para la pantalla
};

void BufferPantalla::SetCursor(uchar posx, uchar posy)
{
	long pos;
	pos = (xmin-1)+x+((ymin-1+y)*80);
	outb(CRTC_COMMAND, CRTC_CURLO);
	outb(CRTC_DATA, (uchar) pos);
	outb(CRTC_COMMAND, CRTC_CURHI);
	pos >>= 8;
	outb(CRTC_DATA, (uchar) pos);
};

void BufferPantalla::textcolor(int color)
{
 if((color&0x0ff7F)<16)	// Quito el bit de blink para comprobar
	atrib=(atrib&0x7000)+(color<<8);
};

void BufferPantalla::textfondo(int color)
{
 if(color<8)
	atrib=(atrib&0x8f00)+(color<<12);
};

void BufferPantalla::textatrib(int color)
{
 if(color<256)
	atrib=color<<8;
};

void BufferPantalla::ir_xy(uchar posx, uchar posy)
{
 if ((posx<=NR_COL)&&(posy<=NR_LIN))
  {
   x=posx;
   y=posy;
   if(ON) SetCursor(posx,posy);
  }
};

void BufferPantalla::puts(const char *s)
{
 uint c;
 Ext_ExclusionMutua(1);
 while( (c = (uchar)(*s++) ) !=0)
 {
	switch (c)
	{
		case 10:
		case 11:
		case 12:
		case 13:
			y++;
			x = 0;
			break;
		case 9: 		//  \t
			c = 8 - (x&7);
			x += c;
			if (x >= NR_COL) {
				x = 0;
				y++;
				}
			c = 9;
			break;
		case 8: 		//  \b backspace
			if (x)	x--;
			else if(y){ y--; x=xmax-xmin; }
			c=' ';
			pantalla[ x + y*NR_COL ] = c + atrib;
			if(on)
				memvideo[(xmin-1)+x+(ymin-1+y)*80]=(ushort) (c+atrib);
			break;
		default:
			pantalla[ x + y*NR_COL ] = c + atrib;
			if(on)
				memvideo[(xmin-1)+x+(ymin-1+y)*80]=(ushort) (c+atrib);
			x++;
			if (x >= NR_COL) {
				x = 0;
				y++;
				}
			break;
	} // end of switch
	if (y >= NR_LIN)
		subir_linea();
  }
 if(ON)
	SetCursor(x,y);
 Ext_ExclusionMutua(0);
};

void BufferPantalla::putn(uint n)
{
  char *a,*b;
  a=(char *)Ext_malloc(512);
  b=number(a, n, 10, 0, 0,2);
  b='\0';
  puts(a);
};

void BufferPantalla::putc(char c)
{
  char *a;
  a=(char *)Ext_malloc(4);
  a[0]=c;
  a[1]='\0';
  puts(a);
};

/*
int BufferPantalla::printk(const char *fmt, ...)
{
	char __far * *args;
	int i;
	char* b;     	// Buffer para el printk
	Ext_ExclusionMutua(1);
	b=(char*)Ext_malloc(sizeof(char)*1024);
	va_start(args, fmt);
	i = vsprintf(b, fmt, args);
	va_end(args);
	puts(b);
	Ext_ExclusionMutua(0);
	return i;
};
*/

void BufferPantalla::clrscr(void)
{
  x=0; y=0;		// Situamos el cursor al principio
  int i;
  for (i=0; i<TAM; i++)
	pantalla[i]=' '+atrib;
  if(on)  volcar_pantalla();  //si la pantalla es visible
};

void BufferPantalla::subir_linea(void)
{
 int i;
 ushort *f, *d=pantalla;
 f=d+NR_COL;
 Ext_memcpy(d,f,(TAM-NR_COL)*2);		// Sube una linea toda la pantalla
 for(i=TAM-1; i>=TAM-NR_COL;i--)		// Borramos la ultima linea
	pantalla[i]=' '+atrib;
 y--;
 if(on) volcar_pantalla();
};

void BufferPantalla::cargar_pantalla()
{
 int i;
 ushort far *v=memvideo;
 ushort far *p=(ushort far*)pantalla;
 v+=(xmin-1+(ymin-1)*80);
 for (i=0;i<NR_LIN;i++,p+=NR_COL,v+=80)
	Ext_CopiarMemoria(v,p,NR_COL*2);
};

void BufferPantalla::volcar_pantalla (void)
{
 int i;
 ushort far *v=memvideo;
 ushort far *p=(ushort far*)pantalla;
 v+=(xmin-1+(ymin-1)*80);
 for (i=0;i<NR_LIN;i++,p+=NR_COL,v+=80)
	Ext_CopiarMemoria(p,v,NR_COL*2);
 if(ON) SetCursor(x,y);
};


/***************************************************************************
	IMPLEMENTACION DE LA CLASE TAREA CON BUFFER DE TECLADO Y PANTALLA
***************************************************************************/
BTask::BTask(void *inicio, char name[], uchar x, uchar y, uchar X, uchar Y):Task(inicio,name),
			BufferPantalla(x,y,X,Y)
{
	tipo=1;		// tipo=1 => tarea BTask
};

void BTask::gets(char *string)
{
  pos=0;
  while( (string[pos]=getche()) != 13 )
	if(string[pos]==8 && pos>0) pos--;
	else if(string[pos]!=8) pos++;

  string[pos]='\0';
};

char BTask::getch()
{
	while((cadena[0]=desapila())==0)
	{
		Desactivar();		// Desactivar la tarea
		Ext_NextTask(1);
	}
	return cadena[0];
};

char BTask::getche()
{
	while((cadena[0]=desapila())==0)
	{
		Desactivar();		// Desactivar la tarea
		Ext_NextTask(1);
	}
	cadena[1]='\0';
	if(pos==0 && cadena[0]==8)
		return cadena[0];
	puts(cadena);
	return cadena[0];
};


/***************************************************************************
			IMPLEMENTACION DE LA CLASE PLANIFICADOR
***************************************************************************/
Plan::Plan(ushort velocidad)
{
	numtareas=0;				// Inicializa variables a cero
	Lista=NULL;
	Ext_TASK_BUFFER[numtareas+1]=0;
	Ext_settimer(velocidad);		// Asigna la velocidad del timer
	Me  = new cMessage(&Sche);
	Mr  = new cMessage(&Sche);
	MB = new cMessageBox(&Sche);
	MS = new cMailBox(&Sche);
	if(MS->AddDriverBox(1,MB)!=bNOERROR)
		TRACE("Error al crear el buzon",10,10);
};


Plan::~Plan()
{
	struct LTask *temp;
	while(Lista!=NULL)			// Elimina todas las tareas que no hayan
	{						//  terminado todavia.
		temp=Lista->sig;
		if(Lista->tarea->tipo==1) DelFoco((BTask *)Lista->tarea);	// Libera el foco de la tarea
		delete(Lista->tarea);	// Llama al destructor de la tarea
		Ext_free(Lista);		// Libera la memoria del nodo de la tarea
		Lista=temp;
	}
//	MS->RemoveDriverBox(MB);
	delete(MB);
	delete(Me);
	delete(Mr);
	delete(MS);	// No hace nada, ya que cada tarea libera su buzon
};

void Plan::planifica()
{
  Ext_ExclusionMutua(0);  			// Abrir multitarea
  do{
	Ext_NextTask(1);        		// Pasa el control a las tareas
	EliminaTerminadas();  			// Borra las tareas terminadas
	if(numtareas==0) break;			// Si no hay tareas instaladas sale
	while(MB->ReturnWait()==1) TrataMens();
  }while(!Dispatch());				// Despacha teclas y sale con ESC
  Ext_ExclusionMutua(1);  			// Cerrar multitarea
}

/*void strcat(char * orig, char * dest)
{
	char *p;
	p=orig;
	while(*orig!=0)*orig++;	// Busca la ultima posicion de orig
	while(*dest!=0)
		*orig++=*dest++;
	*orig++='\0';
	orig=p;
} */

void Plan::Top()
{
	struct LTask *temp=Lista;
	struct BTask *t;
	t=(BTask *)Actual();
	t->puts("ID \tNombre \t\tCuanto \tPila\n");
	while(temp!=NULL)
	{
		t->putn(temp->tarea->getTid());
		t->puts("\t");
		t->puts(temp->tarea->nombre);
		t->puts("\t\t");
		t->putn(temp->tarea->getCount());
		t->puts("\t");
		t->putn(temp->tarea->getStack());
		t->puts("\n");
		temp=temp->sig;
	}
}

void Plan::TrataMens()
{
	int i;
	MB->ReturnMsg(Mr);
	switch(Mr->ReturnFlagFunction())
	{
		case 0:
			break;
		case 1:
			void *p;
			p=Ext_malloc((unsigned)Mr->ReturnInfo());
			Me->SetMsg(Mr->ReturnSource(),Mr->ReturnFunction(),p,sizeof(p));
			Sche->MS->SendMsg(Me);
			break;
		default:
			TRACE("El kernel no reconoce el mensaje",20,15);
	}
}

void Plan::add(Task *Tar, ushort ticks)
{
	struct LTask *nueva;		// Crea un nuevo nodo de la lista de tareas
	nueva=(LTask *)Ext_malloc(sizeof(LTask));	// Reserva memoria del nodo
	numtareas++;				// Incrementa el numero de tareas
	nueva->tarea=Tar;
	nueva->PlanID=numtareas;	// Guarda posicion que estara en buffer tareas
	nueva->sig=Lista;
	Lista=nueva;                // Pone el nuevo nodo al principio de la lista
	Tar->setCount(ticks);		// Asigna los cuantos de ejecucion a la tarea
	Ext_TASK_BUFFER[numtareas]=Tar->getTid();	// Pone la tarea en el buffer
	Ext_TASK_BUFFER[numtareas+1]=0;		//  de tareas.

	if(MS->AddBox(Tar->MB)!=bNOERROR)
	  TRACE("Error al crear el buzon",10,10);

	if(Tar->tipo==1) AddFoco((BTask *)Tar);
};

ushort Plan::getnumtareas()
{
	return numtareas;			// Devuelve el numero de tareas aadidas
}

void Plan::del(Task *Tar)
{
	struct LTask *temp,*ant,*ult;    	// Temporales para recorrer la lista de tareas
	Ext_ExclusionMutua(1);  	// Cerrar multitarea
	temp=ant=ult=Lista;
	if(Tar->tipo==1) DelFoco((BTask *)Tar);	// Libera el foco de la tarea
	MS->RemoveBox(Tar->MB);
	while(temp->tarea!=Tar)		// Mientras no encuentre la tarea en la lista
	{
		ant=temp;
		temp=temp->sig; 		// recorre la lista
	}
	if(temp==ant) Lista=Lista->sig;	// Se borra el primer nodo de la lista
	else ant->sig=temp->sig;		// Se actualiza la lista

	while(ult->PlanID!=numtareas)
	{
		ult=ult->sig;  // Buscamos el ultimo del buffer
		if (ult==NULL) // Si no lo encuentro es que lo acabo de borrar
			ult=temp;  // por lo tanto el que busco es el que quiero borrar.
	}

	ult->PlanID = temp->PlanID;	// Guarda la nueva posicion del buffer
	Ext_TASK_BUFFER[temp->PlanID]=Ext_TASK_BUFFER[numtareas];	//sustituye la tarea
	Ext_TASK_BUFFER[numtareas]=0;	   // borrada por la ultima, y la ultima la anula
	delete(Tar);			   // Libera la memoria y selectores de la tarea
	Ext_free(temp);				// Libera la memoria del nodo.
	numtareas--;				// Resta el numero de tareas
	Ext_ExclusionMutua(0);  		// Abrir multitarea
};

void Plan::EliminaTerminadas()
{
 struct LTask *temp,*ant,*ult;
 Ext_ExclusionMutua(1);  	// Cerrar multitarea
 while(Ext_END_TASKS)   	// Si ha terminado alguna tarea hace el while
 {
	temp=ant=ult=Lista;
	while(!temp->tarea->Terminada())	// Busca la tarea que ha terminado
	{
		ant=temp;
		temp=temp->sig;
	}
	if(temp==ant) Lista=Lista->sig;	// Se borra el primero
	else ant->sig=temp->sig;		// Se borra cualquier otro

	while(ult->PlanID!=numtareas)
	{
		ult=ult->sig;  // Buscamos el ultimo del buffer
		if(ult==NULL)  // Si no lo encuentro es que lo acabo de borrar
			ult=temp;  // por lo tanto el que busco es el que quiero borrar.
	}
	ult->PlanID = temp->PlanID;	// Guarda la nueva posicion del buffer
	Ext_TASK_BUFFER[temp->PlanID]=Ext_TASK_BUFFER[numtareas];
	Ext_TASK_BUFFER[numtareas]=0;

	if(temp->tarea->tipo==1)           // Si la tarea tenia foco
		DelFoco((BTask *)temp->tarea);	// Libera el foco de la tarea
	MS->RemoveBox(temp->tarea->MB);
	delete(temp->tarea);			// Llama al destructor de la tarea
	Ext_free(temp);			   	// Libera la memoria del nodo.
	numtareas--;           		// Resta el numero de tareas
	Ext_END_TASKS--;       		// Resta el numero de tareas terminadas
 }
 Ext_ExclusionMutua(0);  // Abrir multitarea
};

Task *Plan::Actual()	//-----Modificado por McDuck (Sugerencia de Quoosquy)
{
struct LTask *temp=Lista;

	while(temp->tarea->getTid()!=Ext_TASK) temp=temp->sig;
	return temp->tarea;
}

Task *Plan::Whois(void *inicio)
{
struct LTask *temp=Lista;

	while(temp->tarea->Inicio()!=inicio) temp=temp->sig;
	return temp->tarea;
}

/***************************************************************************
			FUNCION TRACE
***************************************************************************/
void TRACE(char *a,int x, int y)
{
 Ext_ExclusionMutua(1);  // Abrir multitarea
  ushort far *p=((ushort far *)Ext_MemoriaVideo)+0x18000/2;
  int i;
  p+=x+y*80;
  for (i=0;i<Ext_strlen(a);i++)
	p[i]=a[i]+(31<<8);
 Ext_ExclusionMutua(0);  // Abrir multitarea
}

void TRACEN(uint n,int x,int y)
{
 Ext_ExclusionMutua(1);  // Abrir multitarea
  ushort far *p=((ushort far *)Ext_MemoriaVideo)+0x18000/2;
  int i;
  p+=x+y*80;
  char *a;
  a=(char *)Ext_malloc(512);
  number(a, n, 10, 0, 0,2);
  for (i=0;i<Ext_strlen(a);i++)
	p[i]=a[i]+(31<<8);
 Ext_ExclusionMutua(0);  // Abrir multitarea
}

/***************************************************************************
			FUNCIONES VSPRINTF Y SPRINTF
***************************************************************************/

static int skip_atoi(const char * far *s)
{
	int i=0;

	while (is_digit(**s))
		i = i*10 + *((*s)++) - '0';
	return i;
}

static char * number(char * str, int num, int base, int size, int precision
	,int type)
{
	char c,sign,tmp[36];
	const char *digits="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	int i;

	if (type&SMALL) digits="0123456789abcdefghijklmnopqrstuvwxyz";
	if (type&LEFT) type &= ~ZEROPAD;
	if (base<2 || base>36)
		return 0;
	c = (type & ZEROPAD) ? '0' : ' ' ;
	if (type&SIGN && num<0) {
		sign='-';
		num = -num;
	} else
		sign=(type&PLUS) ? '+' : ((type&SPACE) ? ' ' : 0);
	if (sign) size--;
	if (type&SPECIAL)
		if (base==16) size -= 2;
		else if (base==8) size--;
	i=0;
	if (num==0)
		tmp[i++]='0';
	else
	{
		while (num!=0)
		{
			tmp[i++]=digits[num%base];
			num=(int)num/base;
		}
	}
	if (i>precision) precision=i;
	size -= precision;
	if (!(type&(ZEROPAD+LEFT)))
		while(size-->0)
			*str++ = ' ';
	if (sign)
		*str++ = sign;
	if (type&SPECIAL)
		if (base==8)
			*str++ = '0';
		else if (base==16) {
			*str++ = '0';
			*str++ = digits[33];
		}
	if (!(type&LEFT))
		while(size-->0)
			*str++ = c;
	while(i<precision--)
		*str++ = '0';
	while(i-->0)
		*str++ = tmp[i];
	while(size-->0)
		*str++ = ' ';
	*str++ = '\0';
	return str;
}
