/*
	Class: 		<cMailBox>
	Version:    1.1
	Autor:		Patricio Clerencia del Pico. 09.1998
	Uso:		Contenedor de buzones.

	Las funciones que provocan errores en error, devuelven:
		0: no ha habido error
        1: se ha incurrido en un error

	Valores de error:
		0: sin error
		1: no hay espacio para ms cMessageBox
		2: no encontrado propietario
		3: el propietario ya posee otro cMessageBox
		4: no hay cajones para eliminar

	Valores de Map[]:
		0: cajn desocupado
		1: cajn ocupado
		2: cajn bloqueado
*/
#include "messbox.h"

#ifndef MAILBOX_H
#define MAILBOX_H

#define MAX_PROCS 1024

#ifndef ZEUS_DEBUG
#define ZEUS_DEBUG
#endif

//Constatex para error
#define bERROR		    -1
#define bNOERROR 		0
#define bNOSPACE 		1
#define bNOFOUNDOWNER   2
#define bOWNERFOUND 	3
#define bNOBOXES		4
#define bEXIST			5
#define bNOEXIST		6
#define bDRIVEREXIST    7
#define bDRIVERNOTEXIST 8

//Constantes para Map[]
#define bFREE 0
#define bUSED 1
#define bBLOCK 2

typedef struct{
		char Map;
		cMessageBox *bBuffer;
}RegMessageBox;

typedef struct tBasicDriver{
    unsigned int DriverId;
    cMessageBox *DriverBox;
    struct tBasicDriver *next;
}BasicDriver;

class cMailBox
{
private:
	void *Owner;
	RegMessageBox BoxArray[MAX_PROCS];
	unsigned int NumBox;
	unsigned int HashFactor;
    BasicDriver *ListOfDrivers;
    BasicDriver *WriteDrivers;

	unsigned int SearchHashFactor();
	unsigned int HashFunction(unsigned int num);
protected:
public:
	int error;
	cMailBox();
	cMailBox(void *ow);
	int AddBox(cMessageBox *mb);
    int AddDriverBox(unsigned int di,cMessageBox *mb);
	cMessageBox *MyBox(void *ow);
	int SendMsg(cMessage *msg);
	int SendCtrl(unsigned int di,cMessage *msg);
	int ExistMessageBox(void *ow);
	int RemoveBox(void *ow);
    int RemoveBox(cMessageBox *mb);
    int RemoveDriverBox(cMessageBox *mb);
	void *ReturnOwner();
	~cMailBox();
};

#endif

