//Implementa <cMessage>
#include <extensor.h>
#include "zeus.h"
#include "message.h"

//Constuctor de Mensajes por defecto
cMessage::cMessage(void *orig)
{
	AdrOrig=orig;
	AdrDest=this;
	lenght=MAX_BUFFER;
	function.FlagFunction=0x0;
	function.FlagDriver=0x0;
	function.Sleep=0x0;
	function.Answer=0x0;
	function.Flow=0x0;
	function.Read=0x0;
    info=Ext_malloc(MAX_BUFFER);
    Ext_memset(info,126,lenght);
};

//Constuctor de Mensajes a partir de otro mensaje
cMessage::cMessage(cMessage *mess)
{
	AdrOrig=mess->AdrOrig;
	AdrDest=mess->AdrDest;
	function=mess->function;
	lenght=mess->lenght;
    info=Ext_malloc(MAX_BUFFER);
    Ext_memcpy(info,mess->info,mess->lenght);
};

//Devuelve el origen del mensaje
void *cMessage::ReturnSource()
{
	return AdrOrig;
};

//Devuelve el destino del mensaje
void *cMessage::ReturnDestination()
{
	return AdrDest;
};

//Devuelve su funcin de uso
tFunctionMsg cMessage::ReturnFunction()
{
	return function;
};

//Devuleve puntero a contenido
void *cMessage::ReturnInfo()
{
    return (void*)info;
};

char *cMessage::ReturnStr()
{
char *cad;

    Ext_ExclusionMutua(1);
    cad=(char*)Ext_malloc(lenght);
    Ext_strcpy(cad,(char*)info);
    cad[lenght]=0;
    Ext_ExclusionMutua(0);
    return cad;
};

//Devuelve el tamao del contenido
size_t cMessage::ReturnInfoSize()
{
	return lenght;
};

//Establece la funcin
void cMessage::SetFunction(tFunctionMsg func)
{
	function=func;
};

//Establece la direccion de destino
void cMessage::SetAdrDest(void *adr)
{
	AdrDest=adr;
};
void cMessage::SetAdrSource(void *adr)
{
    AdrOrig=adr;
};

//Establece el contenido y su tamao
void cMessage::SetInfo(void *dat,size_t siz)
{
	lenght=siz;
	Ext_memcpy(info,dat,siz);
};

//Establece toda la trama de mensaje
void cMessage::SetMsg(void *dest,tFunctionMsg func,void *inf,size_t len)
{
char *cad;

    AdrDest=dest;
    function=func;
    lenght=len;
	Ext_memcpy(info,inf,len);
};

//Destructor de mensaje
cMessage::~cMessage()
{
	Ext_free(info);
};

unsigned int cMessage::ReturnFlagFunction()
{
	return function.FlagFunction;
};
unsigned int cMessage::ReturnFlagDriver()
{
	return function.FlagDriver;
};
unsigned int cMessage::ReturnSleep()
{
	return function.Sleep;
};
unsigned int cMessage::ReturnAnswer()
{
	return function.Answer;
};
unsigned int cMessage::ReturnFlow()
{
	return function.Flow;
};
unsigned int cMessage::ReturnRead()
{
	return function.Read;
};
void cMessage::SetFlagFunction(unsigned int v)
{
	function.FlagFunction=v;
};
void cMessage::SetFlagDriver(unsigned int v)
{
	function.FlagDriver=v;
};
void cMessage::SetSleep(unsigned int v)
{
	function.Sleep=v;
};
void cMessage::SetAnswer(unsigned int v)
{
	function.Answer=v;
};
void cMessage::SetFlow(unsigned int v)
{
	function.Flow=v;
};
void cMessage::SetRead(unsigned int v)
{
	function.Read=v;
};
