/*
	Class: 		<cMessage>
	Versin 	1.0
	Autor:		Patricio Clerencia del Pico. 09.1998
	Uso:		Formato para intercambio de informacin.

	AdrOrig: 	@ de 32 bits.
	AdrDest: 	@ de 32 bits.
	function:	entero de 32 bits.

		* situacin indicadores de funcin
			- 0x------XX	:funcin del mensaje
			- 0x-XXXXX--	:identificador de controlador origen
			- 0xX-------	:bits de estado

		* rango bits funcin 0x00-0xFF

		* rango bits controlador 0x00000-0xFFFFF

		* desglose bits de estado
			- bit 31 		:L indica si ha sido ledo (=1 est ledo)
			- bit 30		:F tipo de flujo (1=BIN, 0=TEXT)
			- bit 29		:R indica si necesita respuesta(=1 necesita)
			- bit 28		:E tras su envo proceso duerme o contina
							 (=1 duerme)
*/
#include <extensor.h>

#ifndef MESSAGE_H
#define MESSAGE_H

#ifndef ZEUS_DEBUG
#define ZEUS_DEBUG
#endif

//#define tFunctionMsg unsigned int
#define MAX_BUFFER 64
#define _FLOW_TEXT_ 0
#define _FLOW_BIN_  1


typedef unsigned size_t;

struct tFunctionMsg{
	unsigned int FlagFunction:8;
	unsigned int FlagDriver:20;
	unsigned int Sleep:1;
	unsigned int Answer:1;
	unsigned int Flow:1;
	unsigned int Read:1;
};

class cMessage
{
private:
protected:
	void *AdrOrig,*AdrDest;			//@origen y @destino
	tFunctionMsg  function; 		//funcin del mensaje
	size_t lenght;					//Longitud del contenido del mensaje
	void *info;						//contenido del mensaje
public:
	cMessage(void *orig);
	cMessage(cMessage *mess);

    void *ReturnSource();
	void *ReturnDestination();
	tFunctionMsg ReturnFunction();
	unsigned int ReturnFlagFunction();
	unsigned int ReturnFlagDriver();
	unsigned int ReturnSleep();
	unsigned int ReturnAnswer();
	unsigned int ReturnFlow();
	unsigned int ReturnRead();
	void *ReturnInfo();
    char *ReturnStr();
	size_t ReturnInfoSize();

	void SetFunction(tFunctionMsg func);
	void SetFlagFunction(unsigned int v);
	void SetFlagDriver(unsigned int v);
	void SetSleep(unsigned int v);
	void SetAnswer(unsigned int v);
	void SetFlow(unsigned int v);
	void SetRead(unsigned int v);
    void SetAdrSource(void *adr);
	void SetAdrDest(void *adr);
	void SetInfo(void *dat,size_t siz);
    void SetMsg(void *dest,tFunctionMsg func,void *inf,size_t len);
	~cMessage();
};

#endif
