/*
	Class: 		<cMessageBox>
    Version:    1.0ext
	Autor:		Patricio Clerencia del Pico. 09.1998
	Uso:		Contenedor de mensajes.

	Las funciones que inducen a error devuelven:
		0: No hay error
		1: Se ha producido un error

	Valor de errores
		0: Sin error
		1: No hay espacio para nuevos mensajes
		2: No se puede eliminar mensaje
		3: Cola de mensajes vaca
		4: Mensaje no se puede borrar hasta ser ledo
		5: Mensaje no se puede borrar hasta ser ledo y respondido

	Valores del tipo tMsgFlasgs
		bit 0 W: Hay mensajes esperando (W(ait)=1)
		bit 1 N: Hay mensajes nuevos (N(ew)=1)
		bit 2 R: Hay mensajes en el sobradero (O(vermsg)=1)
		bits 3-31: Reservado

		xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        --------------- RES --------MONW
		
	Valores para variable MAP[]
		0: Sobre saco
		1: Sobre ocupado
		2: Sobre bloqueado por uso
*/

#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H

#include "message.h"

#ifndef ZEUS_DEBUG
#define ZEUS_DEBUG
#endif

//error
#define mERROR              -1    
#define mNOERROR            0
#define mNOSPACE            1
#define mNOREMOVE           2
#define mNOMESSAGES         3
#define mFIRSTREAD          4
#define mFISTREADANDANSWER  5

//Map[]
#define mFREE  0
#define mUSED  1
#define mBLOCK 2

//IncrementIndex
#define _READMSG      0
#define _WRITEMSG     1

//ReadMsg
#define _REMOVE     0
#define _NOREMOVE   1

struct tMessageNode{
	char Map;
	cMessage *mBuffer;
    struct tMessageNode *next;
};

struct tFlagMsgBox{
	unsigned int Wait:1;
	unsigned int New:1;
	unsigned int OverMsg:1;
    unsigned int MsgMask:1;
    unsigned int Res:28;
};

class cMessageBox
{
private:

	typedef tMessageNode MessageNode;
    void *Owner;            //Propietario
    tFlagMsgBox BoxFlags;   //Flags del Buzon
    MessageNode *ListMsg;   //Registro almacenador de mensajes
    MessageNode *ReadMsg;   //Indice que apunta al primero en leer leer
    MessageNode *WriteMsg;  //Apunta al ltimo mensaje recibido
    MessageNode *AuxMsgNode;//Punterto auxiliar
    int NumMsg;             //n de mensajes en el array
    tFunctionMsg WaitMask;
    cMessage *MsgMasked;    //Mensaje con mscara

protected:
public:
    
    int error;                  //variable que indica errores producidos
    cMessageBox();              //Constructores de la clase
	cMessageBox(void *ow);
    int AddMsg(cMessage *mess); //Mete un mensaje dentro del buzn
	//Devuelve primer mensaje en el buzn (_REMOVE lo borra _NOREMOVE no lo borra)
    int ReturnMsg(cMessage *msg,int r=_REMOVE);
    void *ReturnOwner();        //Devuelve el propietario del buzn
    void PurgueMsg();           //Elimina todos los mensajes del buzn
    void WaitForMsg();          //Espera hasta la llegada de un mensaje
    void WaitForMask(tFunctionMsg m, cMessage *msg);
    int  WaitAndReturn(cMessage *msg,int r=_REMOVE);
    tFlagMsgBox ReturnStatus(); //Devuelve los flags del buzn
    unsigned int ReturnOverMsg();
    unsigned int ReturnNew();
    unsigned int ReturnWait();
    void SetOverMsg(unsigned int v);//Establece Flags del buzn
    void SetNew(unsigned int v);
    void SetWait(unsigned int v);
    ~cMessageBox();             //Destructor de la clase
};
#endif
