/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfFile;
import asf.AsfHeader;
import asf.MediaPacket;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class AsfData
implements AsfConstants {
    private AsfFile asfFile;
    private long objectSize;
    private byte[] fileID;
    private long totalDataPackets;
    private int reserved;
    private MediaPacket mp;
    private BufferedInputStream bis;
    private RandomAccessFile ra;
    private int packetSize;
    private byte[] packetBuffer;
    private long headerLength;

    public AsfData() {
        this.mp = new MediaPacket();
        this.reserved = 257;
    }

    public AsfData(AsfFile asfFile, int n) {
        this.asfFile = asfFile;
        this.headerLength = n;
        try {
            this.bis = new BufferedInputStream(new FileInputStream(asfFile.getFile()));
            this.bis.skip(n);
            byte[] byArray = new byte[50];
            this.bis.read(byArray, 0, byArray.length);
            this.objectSize = ((long)byArray[16] & 0xFFL) + (((long)byArray[17] & 0xFFL) << 8) + (((long)byArray[18] & 0xFFL) << 16) + (((long)byArray[19] & 0xFFL) << 24) + (((long)byArray[20] & 0xFFL) << 32) + (((long)byArray[21] & 0xFFL) << 40) + (((long)byArray[22] & 0xFFL) << 48) + (((long)byArray[23] & 0xFFL) << 56);
            this.fileID = new byte[16];
            System.arraycopy(byArray, 24, this.fileID, 0, 16);
            this.totalDataPackets = ((long)byArray[40] & 0xFFL) + (((long)byArray[41] & 0xFFL) << 8) + (((long)byArray[42] & 0xFFL) << 16) + (((long)byArray[43] & 0xFFL) << 24) + (((long)byArray[44] & 0xFFL) << 32) + (((long)byArray[45] & 0xFFL) << 40) + (((long)byArray[46] & 0xFFL) << 48) + (((long)byArray[47] & 0xFFL) << 56);
            this.reserved = (byArray[48] & 0xFF) + ((byArray[49] & 0xFF) << 8);
            this.mp = new MediaPacket();
            this.packetSize = asfFile.getPacketSize();
            this.packetBuffer = new byte[this.packetSize];
        }
        catch (IOException iOException) {
            System.out.println("IOException " + iOException);
        }
    }

    long getObjectSize() {
        return this.objectSize;
    }

    byte[] getFileID() {
        return this.fileID;
    }

    long getTotalDataPackets() {
        return this.totalDataPackets;
    }

    void setObjectSize(long l) {
        this.objectSize = l;
    }

    void setFileID(byte[] byArray) {
        this.fileID = byArray;
    }

    void setTotalDataPackets(int n) {
        this.totalDataPackets = n;
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[50];
        System.arraycopy(AsfConstants.ASF_Data_Object, 0, byArray, 0, 16);
        for (n = 0; n < 8; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        System.arraycopy(this.fileID, 0, byArray, 24, 16);
        for (n = 0; n < 8; ++n) {
            byArray[40 + n] = (byte)(this.totalDataPackets >> 8 * n);
        }
        byArray[48] = (byte)this.reserved;
        byArray[49] = (byte)(this.reserved >> 8);
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Data_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize : " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 16);
        stringBuffer.append("\t fileID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 40, 8);
        stringBuffer.append("\t Total Data Packets : " + this.totalDataPackets + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 48, 2);
        stringBuffer.append("\t Reserved : shall  be  0x0101\n\n");
        return stringBuffer.toString();
    }

    public void prepareData() {
        try {
            this.ra = new RandomAccessFile(this.asfFile.getFile(), "r");
            this.ra.seek(this.headerLength + 50L);
        }
        catch (IOException iOException) {
            System.out.println("IOException " + iOException);
        }
    }

    int readNextPacketRA() {
        int n = 0;
        try {
            n = this.ra.read(this.packetBuffer, 0, this.packetSize);
            if (n != this.packetSize) {
                return -1;
            }
            n = this.mp.readPacket(this.packetBuffer);
            if (n == -1) {
                return -1;
            }
        }
        catch (IOException iOException) {
            System.out.println("AsfData.readNextPacket : " + iOException);
        }
        return n;
    }

    int readNextPacketRASimply() {
        int n = 0;
        try {
            n = this.ra.read(this.packetBuffer, 0, this.packetSize);
            if (n != this.packetSize) {
                return -1;
            }
            n = this.mp.readPacketSimply(this.packetBuffer);
            if (n == -1) {
                return -1;
            }
        }
        catch (IOException iOException) {
            System.out.println("AsfData.readNextPacket : " + iOException);
        }
        return n;
    }

    boolean seek(int n) {
        boolean bl = true;
        try {
            this.ra.seek(this.headerLength + 50L + (long)(n * this.packetSize));
        }
        catch (IOException iOException) {
            System.out.println("AsfData.seek : " + iOException);
            bl = false;
        }
        return bl;
    }

    int readNextPacket() {
        int n = 0;
        try {
            n = this.bis.read(this.packetBuffer, 0, this.packetSize);
            if (n != this.packetSize) {
                return -1;
            }
            n = this.mp.readPacket(this.packetBuffer);
            if (n == -1) {
                return -1;
            }
        }
        catch (IOException iOException) {
            System.out.println("AsfData.readNextPacket : " + iOException);
        }
        return n;
    }

    int readNextPacketSimply() {
        int n = 0;
        try {
            n = this.bis.read(this.packetBuffer, 0, this.packetSize);
            if (n != this.packetSize) {
                return -1;
            }
            n = this.mp.readPacketSimply(this.packetBuffer);
            if (n == -1) {
                return -1;
            }
        }
        catch (IOException iOException) {
            System.out.println("AsfData.readNextPacket : " + iOException);
        }
        return n;
    }

    void parseMediaPacket(byte[] byArray) {
        this.mp.readPacket(byArray);
    }

    void setPreroll(int n) {
        this.mp.setPreroll(n);
    }

    void setDuration(int n) {
        this.mp.setDuration(n);
    }

    void setPacketSize(int n) {
        this.mp.setMediaPacketSize(n);
    }

    MediaPacket getMediaPacket() {
        return this.mp;
    }

    void disposeMediaPacket() {
        this.mp = null;
    }

    byte[] getMediaPacketByteArray() {
        return this.mp.updatePacketArray();
    }

    String dumpMediaPacketText() {
        return this.mp.dumpText();
    }
}

