/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfData;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import asf.AsfStream;
import asf.BitmapInfoHeader;
import asf.MediaPacket;
import asf.SimpleIndex;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;

public class AsfFile
implements AsfConstants {
    private AsfHeader asfHeader;
    private AsfData asfData;
    private File file;
    private File newFile;
    private byte[] header;
    private int headerLength;
    private byte[] fileID;
    private boolean isValidAsf;
    private ArrayList streamList = new ArrayList();
    private BufferedOutputStream bos;
    private int packetCounter;

    public AsfFile() {
        this.asfHeader = new AsfHeader();
        this.asfData = new AsfData();
    }

    public AsfFile(File file) {
        this.file = file;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[16];
            randomAccessFile.read(byArray);
            this.isValidAsf = Arrays.equals(byArray, AsfConstants.ASF_Header_Object);
            randomAccessFile.read(byArray);
            this.headerLength = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
            this.header = new byte[this.headerLength];
            randomAccessFile.seek(0L);
            randomAccessFile.read(this.header, 0, this.headerLength);
            this.asfHeader = new AsfHeader(this, this.header);
            this.asfData = new AsfData(this, this.headerLength);
        }
        catch (IOException iOException) {
            System.out.println("IOException " + iOException);
        }
    }

    public boolean isValidAsfFile() {
        return this.isValidAsf;
    }

    public File getFile() {
        return this.file;
    }

    public File getNewFile() {
        return this.newFile;
    }

    public long getFileSize() {
        return this.file.length();
    }

    public int getPacketSize() {
        return this.asfHeader.getPacketSize();
    }

    public String dumpHeaderText() {
        return this.asfHeader.dumpText();
    }

    public String dumpHeaderObjectsText() {
        ArrayList arrayList = this.asfHeader.getHeaderObjects();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            AsfHeaderObject asfHeaderObject = (AsfHeaderObject)arrayList.get(i);
            stringBuffer.append(asfHeaderObject.dumpText());
        }
        return stringBuffer.toString();
    }

    public String dumpDataHeaderText() {
        return this.asfData.dumpText();
    }

    public String dumpMediaPacketText() {
        return this.asfData.dumpMediaPacketText();
    }

    public int getHeaderLength() {
        return this.asfHeader.getHeaderLength();
    }

    public void prepareData() {
        this.asfData.prepareData();
    }

    public int readNextPacketRA() {
        ++this.packetCounter;
        return this.asfData.readNextPacketRA();
    }

    public int readNextPacketRASimply() {
        ++this.packetCounter;
        return this.asfData.readNextPacketRASimply();
    }

    public boolean seekPacket(int n) {
        this.packetCounter = n;
        return this.asfData.seek(n);
    }

    public int readNextPacket() {
        ++this.packetCounter;
        return this.asfData.readNextPacket();
    }

    public int readNextPacketSimply() {
        ++this.packetCounter;
        return this.asfData.readNextPacketSimply();
    }

    String getVideoCodec() {
        return this.asfHeader.getVideoCodec();
    }

    String getAudioCodec() {
        return this.asfHeader.getAudioCodec();
    }

    public int getPacketCount() {
        return this.packetCounter;
    }

    public void setFileSize(long l) {
        this.asfHeader.setFileSize(l);
    }

    public void setTotalPacketsCount(int n) {
        this.asfHeader.setTotalPacketsCount(n);
        this.asfData.setTotalDataPackets(n);
    }

    public void setSendDuration() {
        this.asfHeader.setSendDuration(this.getMediaPacket().getSendTime() * 10000L);
    }

    public void setPlayDuration(long l) {
        this.asfHeader.setPlayDuration(l);
    }

    public void setMaximumBitrate(int n) {
        this.asfHeader.setMaximumBitrate(n);
    }

    public void setAsfDataObjectSize(long l) {
        this.asfData.setObjectSize(l);
    }

    public void setNewFile(File file) {
        this.newFile = file;
    }

    public void createNewFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.newFile);
            this.bos = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = this.asfHeader.getByteArray();
            this.bos.write(byArray, 0, byArray.length);
            ArrayList arrayList = this.asfHeader.getHeaderObjects();
            for (int i = 0; i < arrayList.size(); ++i) {
                AsfHeaderObject asfHeaderObject = (AsfHeaderObject)arrayList.get(i);
                byte[] byArray2 = asfHeaderObject.getByteArray();
                this.bos.write(byArray2, 0, byArray2.length);
            }
            byte[] byArray3 = this.asfData.getByteArray();
            this.bos.write(byArray3, 0, byArray3.length);
            this.packetCounter = 0;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    void writeMediaPacketToFile() {
        try {
            byte[] byArray = this.asfData.getMediaPacketByteArray();
            this.bos.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        ++this.packetCounter;
    }

    public void terminateFile() {
        try {
            SimpleIndex simpleIndex = new SimpleIndex();
            simpleIndex.makeSimpleIndex(this.fileID);
            byte[] byArray = simpleIndex.getByteArray();
            this.bos.write(byArray, 0, byArray.length);
            this.bos.flush();
            this.bos.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void rewriteHeader() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.newFile, "rw");
            byte[] byArray = this.asfHeader.getByteArray();
            randomAccessFile.write(byArray);
            ArrayList arrayList = this.asfHeader.getHeaderObjects();
            for (int i = 0; i < arrayList.size(); ++i) {
                AsfHeaderObject asfHeaderObject = (AsfHeaderObject)arrayList.get(i);
                byte[] byArray2 = asfHeaderObject.getByteArray();
                randomAccessFile.write(byArray2);
            }
            byte[] byArray3 = this.asfData.getByteArray();
            randomAccessFile.write(byArray3);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void setNewFileID() {
        this.fileID = this.generateFileID();
        this.asfHeader.setFileID(this.fileID);
        this.asfData.setFileID(this.fileID);
    }

    private byte[] generateFileID() {
        byte[] byArray = new byte[16];
        long l = (long)(Math.random() * 1.0E8);
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)(l >> i);
        }
        return byArray;
    }

    public void createCodecList() {
        this.asfHeader.createCodecList(this.streamList);
    }

    public MediaPacket getMediaPacket() {
        return this.asfData.getMediaPacket();
    }

    public void setPacketSize(int n) {
        this.asfHeader.setPacketSize(n);
        this.asfData.setPacketSize(n);
    }

    public void setPreroll(int n) {
        this.asfHeader.setPreroll(n);
        this.asfData.setPreroll(n);
    }

    public void setDuration(int n) {
        this.asfData.setDuration(n);
    }

    void addAsfStreamFromHeader(AsfStream asfStream) {
        this.streamList.add(asfStream);
    }

    public int addAsfStream(AsfStream asfStream) {
        if (this.hasSameStreamNumber(asfStream.getStreamNumber())) {
            int n = asfStream.getStreamNumber() + 1;
            while (!asfStream.setStreamNumber(n)) {
                if (++n <= 128) continue;
                n = 1;
            }
        }
        this.streamList.add(asfStream);
        this.asfHeader.createStreamProperties(asfStream);
        return asfStream.getStreamNumber();
    }

    private boolean hasSameStreamNumber(int n) {
        for (int i = 0; i < this.streamList.size(); ++i) {
            AsfStream asfStream = (AsfStream)this.streamList.get(i);
            int n2 = asfStream.getStreamNumber();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public void setBitmapInfoHeader(BitmapInfoHeader bitmapInfoHeader) {
        this.asfHeader.setBitmapInfoHeader(bitmapInfoHeader);
    }

    public long getPlayDuration() {
        return this.asfHeader.getPlayDuration();
    }

    public int getPreroll() {
        return this.asfHeader.getPreroll();
    }

    public int getTotalPacketsCount() {
        return this.asfHeader.getTotalPacketsCount();
    }

    public int getMaximumBitrate() {
        return this.asfHeader.getMaximumBitrate();
    }

    public byte[] getHeaderByteArray() {
        return this.header;
    }

    public byte[] getDataHeaderByteArray() {
        return this.asfData.getByteArray();
    }
}

