/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfFile;
import asf.AsfHeaderObject;
import asf.AsfStream;
import asf.BitmapInfoHeader;
import asf.BitrateMutualExclusion;
import asf.CodecList;
import asf.ContentDescription;
import asf.ExtendedContentDescription;
import asf.FileProperties;
import asf.HeaderExtension;
import asf.Padding;
import asf.StreamBitrateProperties;
import asf.StreamProperties;
import asf.UnknownObject;
import java.util.ArrayList;

class AsfHeader
implements AsfConstants {
    private AsfFile asfFile;
    private byte[] header;
    private int headerLength;
    private int numberOfHeaderObjects;
    private ArrayList headerObjectsArray = new ArrayList();
    private FileProperties fileProperties;

    public AsfHeader() {
        this.numberOfHeaderObjects = 2;
        FileProperties fileProperties = new FileProperties();
        fileProperties.setSeekable(true);
        this.headerObjectsArray.add(fileProperties);
        this.headerObjectsArray.add(new HeaderExtension());
    }

    public AsfHeader(AsfFile asfFile, byte[] byArray) {
        AsfHeaderObject asfHeaderObject;
        this.asfFile = asfFile;
        this.header = byArray;
        this.headerLength = (byArray[16] & 0xFF) + ((byArray[17] & 0xFF) << 8) + ((byArray[18] & 0xFF) << 16) + ((byArray[19] & 0xFF) << 24);
        this.numberOfHeaderObjects = byArray[24] & 255 + ((byArray[25] & 0xFF) << 8) + ((byArray[26] & 0xFF) << 16) + ((byArray[27] & 0xFF) << 24);
        int n = 30;
        for (int i = 0; i < this.numberOfHeaderObjects && (asfHeaderObject = this.createHeaderObject(n)) != null; ++i) {
            this.headerObjectsArray.add(asfHeaderObject);
            n += asfHeaderObject.getObjectSize();
        }
        if (this.headerLength != n) {
            System.out.println("AsfHeader  :  header length is wrong value");
        }
    }

    private AsfHeaderObject createHeaderObject(int n) {
        AsfHeaderObject asfHeaderObject = null;
        asfHeaderObject = AsfHeader.checkGUID(AsfConstants.ASF_Content_Description_Object, this.header, n) ? new ContentDescription(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_File_Properties_Object, this.header, n) ? new FileProperties(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Stream_Properties_Object, this.header, n) ? new StreamProperties(this, this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Stream_Bitrate_Properties_Object, this.header, n) ? new StreamBitrateProperties(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Header_Extension_Object, this.header, n) ? new HeaderExtension(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Extended_Content_Description_Object, this.header, n) ? new ExtendedContentDescription(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Codec_List_Object, this.header, n) ? new CodecList(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Padding_Object, this.header, n) ? new Padding(this.header, n) : (AsfHeader.checkGUID(AsfConstants.ASF_Bitrate_Mutual_Exclusion_Object, this.header, n) ? new BitrateMutualExclusion(this.header, n) : new UnknownObject(this.header, n)))))))));
        return asfHeaderObject;
    }

    int getHeaderLength() {
        this.headerLength = 30;
        for (int i = 0; i < this.numberOfHeaderObjects; ++i) {
            AsfHeaderObject asfHeaderObject = (AsfHeaderObject)this.headerObjectsArray.get(i);
            this.headerLength += asfHeaderObject.getObjectSize();
        }
        return this.headerLength;
    }

    ArrayList getHeaderObjects() {
        return this.headerObjectsArray;
    }

    void setFileID(byte[] byArray) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setFileID(byArray);
    }

    void setPreroll(int n) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setPreroll(n);
    }

    void setFileSize(long l) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setFileSize(l);
    }

    void setTotalPacketsCount(int n) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setTotalPacketsCount(n);
    }

    void setPlayDuration(long l) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setPlayDuration(l);
    }

    void setSendDuration(long l) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setSendDuration(l);
    }

    void setMaximumBitrate(int n) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setMaximumBitrate(n);
    }

    void setPacketSize(int n) {
        FileProperties fileProperties = this.getFileProperties();
        fileProperties.setMinimumDataPacketSize(n);
        fileProperties.setMaximumDataPacketSize(n);
    }

    int getPacketSize() {
        FileProperties fileProperties = this.getFileProperties();
        int n = fileProperties.getMinimumDataPacketSize();
        return n;
    }

    long getPlayDuration() {
        FileProperties fileProperties = this.getFileProperties();
        long l = fileProperties.getPlayDuration();
        return l;
    }

    int getPreroll() {
        FileProperties fileProperties = this.getFileProperties();
        int n = fileProperties.getPreroll();
        return n;
    }

    int getTotalPacketsCount() {
        FileProperties fileProperties = this.getFileProperties();
        int n = fileProperties.getPacketsCount();
        return n;
    }

    int getMaximumBitrate() {
        FileProperties fileProperties = this.getFileProperties();
        int n = fileProperties.getMaximumBitrate();
        return n;
    }

    private FileProperties getFileProperties() {
        if (this.fileProperties != null) {
            return this.fileProperties;
        }
        FileProperties fileProperties = null;
        for (int i = 0; i < this.headerObjectsArray.size(); ++i) {
            AsfHeaderObject asfHeaderObject = (AsfHeaderObject)this.headerObjectsArray.get(i);
            if (!(asfHeaderObject instanceof FileProperties)) continue;
            fileProperties = (FileProperties)asfHeaderObject;
            break;
        }
        this.fileProperties = fileProperties;
        return fileProperties;
    }

    void createStreamProperties(AsfStream asfStream) {
        StreamProperties streamProperties = new StreamProperties(asfStream);
        this.headerObjectsArray.add(streamProperties);
        ++this.numberOfHeaderObjects;
    }

    String getVideoCodec() {
        String string = "";
        for (int i = 0; i < this.headerObjectsArray.size(); ++i) {
            StreamProperties streamProperties;
            String string2;
            AsfHeaderObject asfHeaderObject = (AsfHeaderObject)this.headerObjectsArray.get(i);
            if (!(asfHeaderObject instanceof StreamProperties) || !(string2 = (streamProperties = (StreamProperties)asfHeaderObject).getStreamType()).equals("video")) continue;
            string = streamProperties.getCodec();
            break;
        }
        return string;
    }

    String getAudioCodec() {
        String string = "";
        for (int i = 0; i < this.headerObjectsArray.size(); ++i) {
            StreamProperties streamProperties;
            String string2;
            AsfHeaderObject asfHeaderObject = (AsfHeaderObject)this.headerObjectsArray.get(i);
            if (!(asfHeaderObject instanceof StreamProperties) || !(string2 = (streamProperties = (StreamProperties)asfHeaderObject).getStreamType()).equals("audio")) continue;
            string = streamProperties.getCodec();
            break;
        }
        return string;
    }

    void setBitmapInfoHeader(BitmapInfoHeader bitmapInfoHeader) {
        for (int i = 0; i < this.headerObjectsArray.size(); ++i) {
            StreamProperties streamProperties;
            AsfHeaderObject asfHeaderObject = (AsfHeaderObject)this.headerObjectsArray.get(i);
            if (!(asfHeaderObject instanceof StreamProperties) || !(streamProperties = (StreamProperties)asfHeaderObject).getStreamType().equals("video")) continue;
            streamProperties.setBitmapInfoHeader(bitmapInfoHeader);
            break;
        }
    }

    void createCodecList(ArrayList arrayList) {
        CodecList codecList = new CodecList(arrayList);
        this.headerObjectsArray.add(codecList);
        ++this.numberOfHeaderObjects;
    }

    void addAsfStream(AsfStream asfStream) {
        this.asfFile.addAsfStreamFromHeader(asfStream);
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[30];
        System.arraycopy(AsfConstants.ASF_Header_Object, 0, byArray, 0, 16);
        this.headerLength = this.getHeaderLength();
        byArray[16] = (byte)this.headerLength;
        byArray[17] = (byte)(this.headerLength >> 8);
        byArray[18] = (byte)(this.headerLength >> 16);
        byArray[19] = (byte)(this.headerLength >> 24);
        byArray[20] = 0;
        byArray[21] = 0;
        byArray[22] = 0;
        byArray[23] = 0;
        byArray[24] = (byte)this.numberOfHeaderObjects;
        byArray[25] = (byte)(this.numberOfHeaderObjects >> 8);
        byArray[26] = (byte)(this.numberOfHeaderObjects >> 16);
        byArray[27] = (byte)(this.numberOfHeaderObjects >> 24);
        byArray[28] = 1;
        byArray[29] = 2;
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        boolean bl = false;
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Header_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t headerLength  :  " + this.headerLength + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 4);
        stringBuffer.append("\t numberOfHeaderObjects  :  " + this.numberOfHeaderObjects + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 28, 2);
        stringBuffer.append("\t Reserved\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static void appendHexString(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3 = 1;
        for (int i = n; i < n + n2; ++i) {
            int n4;
            if (n3 == 17) {
                stringBuffer.append("\n");
                n3 = 1;
            }
            if ((n4 = byArray[i] & 0xFF) <= 15) {
                stringBuffer.append("0" + Integer.toHexString(n4).toUpperCase());
            } else {
                stringBuffer.append(Integer.toHexString(n4).toUpperCase());
            }
            stringBuffer.append(" ");
            ++n3;
        }
    }

    static boolean checkGUID(byte[] byArray, byte[] byArray2, int n) {
        return byArray2[n] == byArray[0] && byArray2[n + 1] == byArray[1] && byArray2[n + 2] == byArray[2] && byArray2[n + 3] == byArray[3] && byArray2[n + 4] == byArray[4] && byArray2[n + 5] == byArray[5] && byArray2[n + 6] == byArray[6] && byArray2[n + 7] == byArray[7] && byArray2[n + 8] == byArray[8] && byArray2[n + 9] == byArray[9] && byArray2[n + 10] == byArray[10] && byArray2[n + 11] == byArray[11] && byArray2[n + 12] == byArray[12] && byArray2[n + 13] == byArray[13] && byArray2[n + 14] == byArray[14] && byArray2[n + 15] == byArray[15];
    }

    private int searchGUIDAdress(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (this.header[i] != byArray[0] || this.header[i + 1] != byArray[1] || this.header[i + 2] != byArray[2] || this.header[i + 3] != byArray[3] || this.header[i + 4] != byArray[4] || this.header[i + 5] != byArray[5] || this.header[i + 6] != byArray[6] || this.header[i + 7] != byArray[7] || this.header[i + 8] != byArray[8] || this.header[i + 9] != byArray[9] || this.header[i + 10] != byArray[10] || this.header[i + 11] != byArray[11] || this.header[i + 12] != byArray[12] || this.header[i + 13] != byArray[13] || this.header[i + 14] != byArray[14] || this.header[i + 15] != byArray[15]) continue;
            n = i;
            break;
        }
        return n;
    }
}

