/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfFile;
import asf.MediaObject;
import asf.MediaPacket;
import asf.Payload;
import java.util.ArrayList;

public class AsfPacketizer {
    private AsfFile asfFile;
    private MediaPacket mp;
    private int numberOfPayloadInUse;
    private int payloadHeaderLength = 17;
    private ArrayList payloadPool;
    private int mpPacketSize;
    private int margin = 30;
    private int maxDataSizeOfSinglePayload;
    private int maxDataSizeOfMultiplePayload;
    private boolean packetIsFull;

    public AsfPacketizer(AsfFile asfFile) {
        this.asfFile = asfFile;
        this.mp = asfFile.getMediaPacket();
        this.mp.makeOrdinarySetting();
        this.mpPacketSize = this.mp.getObjectSize();
        this.maxDataSizeOfSinglePayload = this.mpPacketSize - 26;
        this.maxDataSizeOfMultiplePayload = this.mpPacketSize - 46;
        this.payloadPool = new ArrayList();
    }

    public void addMediaObject(MediaObject mediaObject) {
        int n = mediaObject.restLength();
        while (n != 0) {
            Payload payload = this.createPayload();
            this.packetize(payload, mediaObject);
            this.mp.addPayload(payload);
            if (this.mp.getNumberOfPayloads() == 63) {
                this.packetIsFull = true;
            }
            n = mediaObject.restLength();
            if (!this.packetIsFull) continue;
            this.asfFile.writeMediaPacketToFile();
            this.mp.reset();
            this.mp.updateSendTime();
            this.numberOfPayloadInUse = 0;
        }
    }

    public void flush() {
        this.asfFile.writeMediaPacketToFile();
    }

    private Payload createPayload() {
        Payload payload = null;
        if (this.payloadPool.size() > this.numberOfPayloadInUse) {
            payload = (Payload)this.payloadPool.get(this.numberOfPayloadInUse);
        } else {
            payload = new Payload(this.mp);
            this.payloadPool.add(payload);
        }
        ++this.numberOfPayloadInUse;
        return payload;
    }

    private void packetize(Payload payload, MediaObject mediaObject) {
        int n = mediaObject.restLength();
        int n2 = 0;
        if (this.mp.isVacant()) {
            if (n >= this.maxDataSizeOfSinglePayload) {
                this.mp.setMultiple(false);
                payload.setMultiple(false);
                this.mp.setPaddingLengthType(0);
                n2 = this.maxDataSizeOfSinglePayload;
                this.packetIsFull = true;
            } else if (n >= this.maxDataSizeOfMultiplePayload - this.margin) {
                this.mp.setMultiple(false);
                payload.setMultiple(false);
                n2 = n;
                this.packetIsFull = true;
            } else {
                this.mp.setMultiple(false);
                payload.setMultiple(false);
                n2 = n;
                this.packetIsFull = false;
            }
        } else {
            this.mp.setMultiple(true);
            payload.setMultiple(true);
            int n3 = this.mp.restLength();
            this.payloadHeaderLength = 17;
            int n4 = MediaPacket.decodeLengthType(this.mp.getPaddingLengthType());
            if (n + this.payloadHeaderLength >= n3 + n4) {
                this.mp.setPaddingLengthType(0);
                n2 = n3 + n4 - this.payloadHeaderLength;
                this.packetIsFull = true;
            } else if (n + this.payloadHeaderLength >= n3 - this.margin) {
                n2 = n;
                this.packetIsFull = true;
            } else {
                n2 = n;
                this.packetIsFull = false;
            }
        }
        payload.setDataArray(mediaObject.getDataArrayRef(), mediaObject.getCurrentDataAddress(), n2);
        payload.setValueFromMediaObject(mediaObject);
        mediaObject.setDataAddressFwd(n2);
    }
}

