/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import java.util.Arrays;

public class BitrateMutualExclusion
extends AsfHeaderObject {
    private int objectSize;
    private byte[] exclusionType = new byte[16];
    private int streamNumbersCount;
    private byte[] streamNumbers;
    private byte[] returnBytes;

    public BitrateMutualExclusion(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        System.arraycopy(byArray, n + 24, this.exclusionType, 0, 16);
        this.streamNumbersCount = byArray[n + 40] & 0xFF;
        this.streamNumbers = new byte[this.objectSize - 41];
        System.arraycopy(byArray, n + 41, this.streamNumbers, 0, this.objectSize - 41);
        this.returnBytes = new byte[this.objectSize];
        System.arraycopy(byArray, n, this.returnBytes, 0, this.objectSize);
    }

    int getObjectSize() {
        return this.objectSize;
    }

    byte[] getByteArray() {
        return this.returnBytes;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 0, 16);
        stringBuffer.append("\t ASF_Bitrate_Mutual_Exclusion_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 16, 8);
        stringBuffer.append("\t objectSize\n");
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 24, 16);
        stringBuffer.append("\t Exclusion Type  GUID : ");
        if (Arrays.equals(this.exclusionType, AsfConstants.ASF_Mutex_Language)) {
            stringBuffer.append("ASF_Mutex_Language\n");
        } else if (Arrays.equals(this.exclusionType, AsfConstants.ASF_Mutex_Bitrate)) {
            stringBuffer.append("ASF_Mutex_Bitrate\n");
        } else if (Arrays.equals(this.exclusionType, AsfConstants.ASF_Mutex_Unknown)) {
            stringBuffer.append("ASF_Mutex_Unknown\n");
        }
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 40, 1);
        stringBuffer.append("\t\t\t streamNumbersCount : " + this.streamNumbersCount + "\n");
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 41, this.streamNumbers.length);
        stringBuffer.append("\t\t streamNumbers\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

