/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import asf.AsfStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;

class CodecList
extends AsfHeaderObject {
    private int objectSize;
    private byte[] reserved;
    private int codecEntriesCount;
    private int[] codecType;
    private int[] codecNameLength;
    private byte[][] codecNameArray;
    private int[] codecDescriptionLength;
    private byte[][] codecDescriptionArray;
    private int[] codecInformationLength;
    private byte[][] codecInformationArray;
    private String nullString;

    public CodecList(ArrayList arrayList) {
        int n;
        this.reserved = AsfConstants.ASF_Reserved_2;
        this.codecEntriesCount = arrayList.size();
        this.codecType = new int[this.codecEntriesCount];
        this.codecNameLength = new int[this.codecEntriesCount];
        this.codecNameArray = new byte[this.codecEntriesCount][];
        this.codecDescriptionLength = new int[this.codecEntriesCount];
        this.codecDescriptionArray = new byte[this.codecEntriesCount][];
        this.codecInformationLength = new int[this.codecEntriesCount];
        this.codecInformationArray = new byte[this.codecEntriesCount][];
        this.makeNullString();
        for (n = 0; n < this.codecEntriesCount; ++n) {
            AsfStream asfStream = (AsfStream)arrayList.get(n);
            this.codecType[n] = asfStream.getStreamType();
            String string = asfStream.getCodec();
            if (this.codecType[n] == 1) {
                this.setVideoCodecVariables(string, n);
                continue;
            }
            if (this.codecType[n] != 2) continue;
            this.setAudioCodecVariables(string, n);
        }
        this.objectSize = 44;
        for (n = 0; n < this.codecEntriesCount; ++n) {
            this.objectSize += 8 + this.codecNameLength[n] * 2 + this.codecDescriptionLength[n] * 2 + this.codecInformationLength[n];
        }
    }

    public CodecList(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.reserved = new byte[16];
        System.arraycopy(byArray, n + 24, this.reserved, 0, 16);
        this.codecEntriesCount = (byArray[n + 40] & 0xFF) + ((byArray[n + 41] & 0xFF) << 8) + ((byArray[n + 42] & 0xFF) << 16) + ((byArray[n + 43] & 0xFF) << 24);
        this.codecType = new int[this.codecEntriesCount];
        this.codecNameLength = new int[this.codecEntriesCount];
        this.codecNameArray = new byte[this.codecEntriesCount][];
        this.codecDescriptionLength = new int[this.codecEntriesCount];
        this.codecDescriptionArray = new byte[this.codecEntriesCount][];
        this.codecInformationLength = new int[this.codecEntriesCount];
        this.codecInformationArray = new byte[this.codecEntriesCount][];
        int n2 = n + 44;
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            this.codecType[i] = (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
            this.codecNameLength[i] = (byArray[n2 + 2] & 0xFF) + ((byArray[n2 + 3] & 0xFF) << 8);
            this.codecNameArray[i] = new byte[this.codecNameLength[i] * 2];
            System.arraycopy(byArray, n2 + 4, this.codecNameArray[i], 0, this.codecNameLength[i] * 2);
            this.codecDescriptionLength[i] = (byArray[n2 += 4 + this.codecNameLength[i] * 2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
            this.codecDescriptionArray[i] = new byte[this.codecDescriptionLength[i] * 2];
            System.arraycopy(byArray, n2 + 2, this.codecDescriptionArray[i], 0, this.codecDescriptionLength[i] * 2);
            this.codecInformationLength[i] = (byArray[n2 += 2 + this.codecDescriptionLength[i] * 2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
            this.codecInformationArray[i] = new byte[this.codecInformationLength[i]];
            System.arraycopy(byArray, n2 + 2, this.codecInformationArray[i], 0, this.codecInformationLength[i]);
            n2 += 2 + this.codecInformationLength[i];
        }
        this.makeNullString();
    }

    private void makeNullString() {
        try {
            byte[] byArray = new byte[]{0, 0};
            this.nullString = new String(byArray, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }

    private String arrayToUTFString(byte[] byArray) {
        String string = "";
        try {
            string = new String(byArray, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        return string;
    }

    private String arrayToASCIIString(byte[] byArray) {
        String string = "";
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
            return string;
        }
    }

    private String cutNullString(String string) {
        if (string.length() > 0 && string.substring(string.length() - 1).equals(this.nullString)) {
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return string;
    }

    private void setVideoCodecVariables(String string, int n) {
        try {
            if (string.equals("WMV3")) {
                this.codecNameLength[n] = 22;
                this.codecNameArray[n] = ("Windows Media Video 9" + this.nullString).getBytes("UTF-16LE");
                this.codecDescriptionLength[n] = 1;
                this.codecDescriptionArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecInformationLength[n] = 4;
                this.codecInformationArray[n] = string.getBytes("US-ASCII");
            } else if (string.equals("WMV2")) {
                this.codecNameLength[n] = 23;
                this.codecNameArray[n] = ("Windows Media Video V8\u0000" + this.nullString).getBytes("UTF-16LE");
                this.codecDescriptionLength[n] = 1;
                this.codecDescriptionArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecInformationLength[n] = 4;
                this.codecInformationArray[n] = string.getBytes("US-ASCII");
            } else if (string.equals("WMV1")) {
                this.codecNameLength[n] = 23;
                this.codecNameArray[n] = ("Windows Media Video V7\u0000" + this.nullString).getBytes("UTF-16LE");
                this.codecDescriptionLength[n] = 1;
                this.codecDescriptionArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecInformationLength[n] = 4;
                this.codecInformationArray[n] = string.getBytes("US-ASCII");
            } else {
                this.codecNameLength[n] = 8;
                this.codecNameArray[n] = ("Unknown" + this.nullString).getBytes("UTF-16LE");
                this.codecDescriptionLength[n] = 1;
                this.codecDescriptionArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecInformationLength[n] = string.length();
                this.codecInformationArray[n] = string.getBytes("US-ASCII");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }

    private void setAudioCodecVariables(String string, int n) {
        try {
            if (string.equals("WMA")) {
                this.codecNameLength[n] = 20;
                this.codecNameArray[n] = ("Windows Media Audio" + this.nullString).getBytes("UTF-16LE");
                this.codecDescriptionLength[n] = 1;
                this.codecDescriptionArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecInformationLength[n] = 2;
                this.codecInformationArray[n][0] = 97;
                this.codecInformationArray[n][1] = 1;
            } else {
                this.codecNameLength[n] = 1;
                this.codecNameArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecDescriptionLength[n] = 1;
                this.codecDescriptionArray[n] = this.nullString.getBytes("UTF-16LE");
                this.codecInformationLength[n] = 2;
                this.codecInformationArray[n][0] = 0;
                this.codecInformationArray[n][1] = 0;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }

    public String getVideoCodecName() {
        String string = "--------";
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            if (this.codecType[i] != 1) continue;
            string = this.arrayToUTFString(this.codecNameArray[i]);
            break;
        }
        return this.cutNullString(string);
    }

    public String getAudioCodecName() {
        String string = "--------";
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            if (this.codecType[i] != 2) continue;
            string = this.arrayToUTFString(this.codecNameArray[i]);
            break;
        }
        return this.cutNullString(string);
    }

    public String getVideoCodecDescription() {
        String string = "--------";
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            if (this.codecType[i] != 1) continue;
            string = this.arrayToUTFString(this.codecDescriptionArray[i]);
            break;
        }
        return this.cutNullString(string);
    }

    public String getAudioCodecDescription() {
        String string = "--------";
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            if (this.codecType[i] != 2) continue;
            string = this.arrayToUTFString(this.codecDescriptionArray[i]);
            break;
        }
        return this.cutNullString(string);
    }

    int getObjectSize() {
        return this.objectSize;
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Codec_List_Object, 0, byArray, 0, 16);
        for (n = 0; n < 4; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[20 + n] = 0;
        }
        System.arraycopy(this.reserved, 0, byArray, 24, 16);
        for (n = 0; n < 4; ++n) {
            byArray[40 + n] = (byte)(this.codecEntriesCount >> 8 * n);
        }
        n = 44;
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            int n2;
            byArray[n] = (byte)this.codecType[i];
            byArray[n + 1] = (byte)(this.codecType[i] >> 8);
            byArray[n + 2] = (byte)this.codecNameLength[i];
            byArray[n + 3] = (byte)(this.codecNameLength[i] >> 8);
            n += 4;
            for (n2 = 0; n2 < this.codecNameLength[i] * 2; ++n2) {
                byArray[n + n2] = this.codecNameArray[i][n2];
            }
            byArray[n += this.codecNameLength[i] * 2] = (byte)this.codecDescriptionLength[i];
            byArray[n + 1] = (byte)(this.codecDescriptionLength[i] >> 8);
            n += 2;
            for (n2 = 0; n2 < this.codecDescriptionLength[i] * 2; ++n2) {
                byArray[n + n2] = this.codecDescriptionArray[i][n2];
            }
            byArray[n += this.codecDescriptionLength[i] * 2] = (byte)this.codecInformationLength[i];
            byArray[n + 1] = (byte)(this.codecInformationLength[i] >> 8);
            n += 2;
            for (n2 = 0; n2 < this.codecInformationLength[i]; ++n2) {
                byArray[n + n2] = this.codecInformationArray[i][n2];
            }
            n += this.codecInformationLength[i];
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Codec_List_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 16);
        stringBuffer.append("\t reserved  GUID : ");
        if (Arrays.equals(this.reserved, AsfConstants.ASF_Reserved_2)) {
            stringBuffer.append("ASF_Reserved_2\n");
        } else {
            stringBuffer.append("???\n");
        }
        AsfHeader.appendHexString(stringBuffer, byArray, 40, 4);
        stringBuffer.append("\t\t\t Codec Entries Count : " + this.codecEntriesCount + "\n\n");
        int n = 0;
        for (int i = 0; i < this.codecEntriesCount; ++i) {
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + n, 2);
            stringBuffer.append("\t\t\t Codec Type : ");
            if (this.codecType[i] == 1) {
                stringBuffer.append("video\n");
            } else if (this.codecType[i] == 2) {
                stringBuffer.append("audio\n");
            } else {
                stringBuffer.append("unknown\n");
            }
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + (n += 2), 2);
            stringBuffer.append("\t\t\t Codec Name Length : " + this.codecNameLength[i] + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + (n += 2), this.codecNameLength[i] * 2);
            stringBuffer.append("\t Codec Name : " + this.arrayToUTFString(this.codecNameArray[i]) + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + (n += this.codecNameLength[i] * 2), 2);
            stringBuffer.append("\t\t\t Codec Description Length : " + this.codecDescriptionLength[i] + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + (n += 2), this.codecDescriptionLength[i] * 2);
            stringBuffer.append("\t Codec Description : " + this.arrayToUTFString(this.codecDescriptionArray[i]) + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + (n += this.codecDescriptionLength[i] * 2), 2);
            stringBuffer.append("\t\t\t Codec Information Length : " + this.codecInformationLength[i] + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 44 + (n += 2), this.codecInformationLength[i]);
            stringBuffer.append("\t\t\t Codec Information : " + this.arrayToASCIIString(this.codecInformationArray[i]) + "\n");
            stringBuffer.append("\n");
            n += this.codecInformationLength[i];
        }
        return stringBuffer.toString();
    }
}

