/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;

class CodecSpecificData {
    private int objectSize;
    private int dwSamplresPerBlock;
    private int wEncodeOptions;
    private int dwSuperBlockAlign;
    private int formatTag;
    private byte[] refuge;

    public CodecSpecificData() {
    }

    public CodecSpecificData(byte[] byArray, int n, int n2, int n3) {
        this.objectSize = n2;
        this.formatTag = n3;
        if (n3 == 353 || n3 == 354 || n3 == 355) {
            this.dwSamplresPerBlock = (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
            this.wEncodeOptions = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8);
            this.dwSuperBlockAlign = (byArray[n + 6] & 0xFF) + ((byArray[n + 7] & 0xFF) << 8) + ((byArray[n + 8] & 0xFF) << 16) + ((byArray[n + 9] & 0xFF) << 24);
        } else {
            this.refuge = new byte[this.objectSize];
            System.arraycopy(byArray, n, this.refuge, 0, n2);
            System.out.println("formatTag is not WMA    formatTag : " + n3);
        }
    }

    String getCodecString() {
        String string = "---";
        if (this.formatTag == 353) {
            string = "Windows Media Audio";
        } else if (this.formatTag == 354) {
            string = "Windows Media Audio 9 Professional";
        } else if (this.formatTag == 355) {
            string = "Windows Media Audio 9 Lossless";
        } else if (this.formatTag == 1) {
            string = "PCM audio";
        }
        return string;
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        if (this.formatTag == 353 || this.formatTag == 354 || this.formatTag == 355) {
            byArray[0] = (byte)this.dwSamplresPerBlock;
            byArray[1] = (byte)(this.dwSamplresPerBlock >> 8);
            byArray[2] = (byte)(this.dwSamplresPerBlock >> 16);
            byArray[3] = (byte)(this.dwSamplresPerBlock >> 24);
            byArray[4] = (byte)this.wEncodeOptions;
            byArray[5] = (byte)(this.wEncodeOptions >> 8);
            byArray[6] = (byte)this.dwSuperBlockAlign;
            byArray[7] = (byte)(this.dwSuperBlockAlign >> 8);
            byArray[8] = (byte)(this.dwSuperBlockAlign >> 16);
            byArray[9] = (byte)(this.dwSuperBlockAlign >> 24);
        } else {
            System.arraycopy(this.refuge, 0, byArray, 0, this.objectSize);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        if (this.formatTag == 353 || this.formatTag == 354 || this.formatTag == 355) {
            AsfHeader.appendHexString(stringBuffer, byArray, 0, 4);
            stringBuffer.append("\t dwSamplresPerBlock\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 4, 2);
            stringBuffer.append("\t wEncodeOptions\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 6, 4);
            stringBuffer.append("\t dwSuperBlockAlign\n");
        } else {
            AsfHeader.appendHexString(stringBuffer, byArray, 0, this.objectSize);
            stringBuffer.append("\t formatTag is not WMA\n");
        }
        return stringBuffer.toString();
    }
}

