/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import java.util.Arrays;

class HeaderExtension
extends AsfHeaderObject {
    private int objectSize;
    private byte[] reserved1 = new byte[16];
    private int reserved2;
    private int headerExtensionDataSize;
    private byte[] headerExtensionData;

    public HeaderExtension() {
        this.objectSize = 46;
        System.arraycopy(AsfConstants.ASF_Reserved_1, 0, this.reserved1, 0, 16);
        this.reserved2 = 6;
        this.headerExtensionDataSize = 0;
        this.headerExtensionData = new byte[this.headerExtensionDataSize];
    }

    public HeaderExtension(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        System.arraycopy(byArray, n + 24, this.reserved1, 0, 16);
        this.reserved2 = byArray[n + 40] & 255 + ((byArray[n + 41] & 0xFF) << 8);
        this.headerExtensionDataSize = (byArray[n + 42] & 0xFF) + ((byArray[n + 43] & 0xFF) << 8) + ((byArray[n + 44] & 0xFF) << 16) + ((byArray[n + 45] & 0xFF) << 24);
        this.headerExtensionData = new byte[this.headerExtensionDataSize];
        if (this.headerExtensionData.length > 0) {
            System.arraycopy(byArray, n + 46, this.headerExtensionData, 0, this.headerExtensionDataSize);
        }
    }

    int getObjectSize() {
        return this.objectSize;
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Header_Extension_Object, 0, byArray, 0, 16);
        for (n = 0; n < 4; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[20 + n] = 0;
        }
        System.arraycopy(this.reserved1, 0, byArray, 24, 16);
        byArray[40] = (byte)this.reserved2;
        byArray[41] = (byte)(this.reserved2 >> 8);
        for (n = 0; n < 4; ++n) {
            byArray[42 + n] = (byte)(this.headerExtensionDataSize >> 8 * n);
        }
        if (this.headerExtensionDataSize > 0 && this.objectSize > this.headerExtensionDataSize + 46) {
            System.arraycopy(this.headerExtensionData, 0, byArray, 0, this.headerExtensionDataSize);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Header_Extension_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 16);
        if (Arrays.equals(this.reserved1, AsfConstants.ASF_Reserved_1)) {
            stringBuffer.append("\t Reserved Field 1 : ASF_Reserved_1\n");
        } else {
            stringBuffer.append("\t Reserved Field 1\n");
        }
        AsfHeader.appendHexString(stringBuffer, byArray, 40, 2);
        stringBuffer.append("\t Reserved Field 2\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 42, 4);
        stringBuffer.append("\t Header Extension Data Size : " + this.headerExtensionDataSize + "\n");
        if (this.headerExtensionDataSize > 0 && this.objectSize > this.headerExtensionDataSize + 46) {
            AsfHeader.appendHexString(stringBuffer, byArray, 46, this.headerExtensionDataSize);
            stringBuffer.append("\t Header Extension Data\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

