/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.Payload;
import java.util.ArrayList;

public class MediaPacket
implements AsfConstants {
    private int objectSize;
    private boolean hasErrorCorrection;
    private int errorCorrectionLengthType;
    private boolean hasOpaqueData;
    private int errorCorrectionDataLength;
    private byte[] errorCorrectionData;
    private boolean hasErrorCorrection2;
    private int packetLengthType;
    private int paddingLengthType;
    private int sequenceLengthType;
    private int streamNumberLengthType;
    private int mediaObjectNumberLengthType;
    private int offsetOrPresentationTimeLengthType;
    private int replicatedDataLengthType;
    private int packetLength;
    private int sequence;
    private int paddingLength;
    private long sendTime;
    private long duration;
    private int caluculatedPaddingLength;
    private boolean multiplePayload;
    private int numberOfPayloads;
    private int payloadLengthType;
    private ArrayList payloadArrayList = new ArrayList();
    private byte[] packet;
    private byte[] newPacket;
    private long sendTimeOffset;
    private int packetCounter;
    private boolean packetIsVacant;
    private long preroll;
    private long diffLimit = 500L;
    private long initialDuration;

    public void makeOrdinarySetting() {
        this.hasErrorCorrection = true;
        this.errorCorrectionLengthType = 0;
        this.hasOpaqueData = false;
        this.errorCorrectionDataLength = 2;
        this.errorCorrectionData = new byte[this.errorCorrectionDataLength];
        this.errorCorrectionData[0] = 0;
        this.errorCorrectionData[1] = 0;
        this.paddingLengthType = 4;
        this.streamNumberLengthType = 1;
        this.mediaObjectNumberLengthType = 1;
        this.offsetOrPresentationTimeLengthType = 3;
        this.replicatedDataLengthType = 1;
        this.payloadLengthType = 2;
        this.newPacket = new byte[this.objectSize];
        this.newPacket[0] = (byte)((this.booleanToInt(this.hasErrorCorrection) << 7 & 0x80) + (this.errorCorrectionLengthType << 5 & 0x60) + (this.booleanToInt(this.hasOpaqueData) << 4 & 0x10) + (this.errorCorrectionDataLength & 0xF));
        this.newPacket[1] = this.errorCorrectionData[0];
        this.newPacket[2] = this.errorCorrectionData[1];
        this.newPacket[4] = (byte)((this.streamNumberLengthType << 6) + (this.mediaObjectNumberLengthType << 4) + (this.offsetOrPresentationTimeLengthType << 2) + (this.replicatedDataLengthType & 3));
    }

    int readPacketSimply(byte[] byArray) {
        this.packet = byArray;
        this.objectSize = byArray.length;
        int n = 0;
        if (AsfHeader.checkGUID(AsfConstants.ASF_Simple_Index_Object, byArray, 0)) {
            return -1;
        }
        this.packetLengthType = (byArray[3] & 0x60) >> 5;
        this.paddingLengthType = (byArray[3] & 0x18) >> 3;
        this.sequenceLengthType = (byArray[3] & 6) >> 1;
        n = 5;
        this.packetLength = this.readLength(byArray, this.packetLengthType, n);
        this.sequence = this.readLength(byArray, this.sequenceLengthType, n += MediaPacket.decodeLengthType(this.packetLengthType));
        this.paddingLength = this.readLength(byArray, this.paddingLengthType, n += MediaPacket.decodeLengthType(this.sequenceLengthType));
        this.sendTime = ((long)byArray[n += MediaPacket.decodeLengthType(this.paddingLengthType)] & 0xFFL) + (((long)byArray[1 + n] & 0xFFL) << 8) + (((long)byArray[2 + n] & 0xFFL) << 16) + (((long)byArray[3 + n] & 0xFFL) << 24);
        ++this.packetCounter;
        return this.objectSize;
    }

    int readPacket(byte[] byArray) {
        this.packet = byArray;
        this.objectSize = byArray.length;
        int n = 0;
        if (AsfHeader.checkGUID(AsfConstants.ASF_Simple_Index_Object, byArray, 0)) {
            return -1;
        }
        if ((byArray[0] & 0xFF) == 130) {
            this.hasErrorCorrection = true;
            this.errorCorrectionLengthType = 0;
            this.hasOpaqueData = false;
            this.errorCorrectionDataLength = 2;
            this.errorCorrectionData = new byte[this.errorCorrectionDataLength];
            this.errorCorrectionData[0] = 0;
            this.errorCorrectionData[1] = 0;
        } else {
            this.hasErrorCorrection = (byArray[0] & 0x80) == 128;
            this.errorCorrectionLengthType = (byArray[0] & 0x60) >> 5;
            this.hasOpaqueData = (byArray[0] & 0x10) == 16;
            this.errorCorrectionDataLength = byArray[0] & 0xF;
            this.errorCorrectionData = new byte[this.errorCorrectionDataLength];
            System.arraycopy(byArray, 1, this.errorCorrectionData, 0, this.errorCorrectionDataLength);
        }
        this.hasErrorCorrection2 = (byArray[3] & 0x80) == 128;
        this.packetLengthType = (byArray[3] & 0x60) >> 5;
        this.paddingLengthType = (byArray[3] & 0x18) >> 3;
        this.sequenceLengthType = (byArray[3] & 6) >> 1;
        this.multiplePayload = (byArray[3] & 1) == 1;
        this.streamNumberLengthType = (byArray[4] & 0xC0) >> 6;
        this.mediaObjectNumberLengthType = (byArray[4] & 0x30) >> 4;
        this.offsetOrPresentationTimeLengthType = (byArray[4] & 0xC) >> 2;
        this.replicatedDataLengthType = byArray[4] & 3;
        n = 5;
        this.packetLength = this.readLength(byArray, this.packetLengthType, n);
        this.sequence = this.readLength(byArray, this.sequenceLengthType, n += MediaPacket.decodeLengthType(this.packetLengthType));
        this.paddingLength = this.readLength(byArray, this.paddingLengthType, n += MediaPacket.decodeLengthType(this.sequenceLengthType));
        this.sendTime = ((long)byArray[n += MediaPacket.decodeLengthType(this.paddingLengthType)] & 0xFFL) + (((long)byArray[1 + n] & 0xFFL) << 8) + (((long)byArray[2 + n] & 0xFFL) << 16) + (((long)byArray[3 + n] & 0xFFL) << 24);
        this.duration = ((long)byArray[4 + n] & 0xFFL) + (((long)byArray[5 + n] & 0xFFL) << 8);
        n += 6;
        this.payloadArrayList.clear();
        if (this.multiplePayload) {
            this.numberOfPayloads = byArray[n] & 0x3F;
            this.payloadLengthType = (byArray[n] & 0xC0) >> 6;
            ++n;
            for (int i = 0; i < this.numberOfPayloads; ++i) {
                Payload payload = new Payload(byArray, n, this);
                this.payloadArrayList.add(payload);
                if ((n += payload.getObjectSize()) <= this.objectSize) continue;
                System.out.println("offset > objectSize");
                break;
            }
        } else {
            this.numberOfPayloads = 1;
            this.payloadLengthType = 0;
            Payload payload = new Payload(byArray, n, this);
            this.payloadArrayList.add(payload);
        }
        ++this.packetCounter;
        return this.objectSize;
    }

    byte[] getByteArray() {
        int n;
        if (this.newPacket == null) {
            this.newPacket = new byte[this.objectSize];
        }
        this.newPacket[0] = (byte)((this.booleanToInt(this.hasErrorCorrection) << 7 & 0x80) + (this.errorCorrectionLengthType << 5 & 0x60) + (this.booleanToInt(this.hasOpaqueData) << 4 & 0x10) + (this.errorCorrectionDataLength & 0xF));
        this.newPacket[1] = this.errorCorrectionData[0];
        this.newPacket[2] = this.errorCorrectionData[1];
        this.newPacket[3] = (byte)((this.booleanToInt(this.hasErrorCorrection2) << 7) + (this.packetLengthType << 5) + (this.paddingLengthType << 3) + (this.sequenceLengthType << 1) + (this.booleanToInt(this.multiplePayload) & 1));
        this.newPacket[4] = (byte)((this.streamNumberLengthType << 6) + (this.mediaObjectNumberLengthType << 4) + (this.offsetOrPresentationTimeLengthType << 2) + (this.replicatedDataLengthType & 3));
        int n2 = 5;
        n2 = MediaPacket.writeByteWithLengthType(this.newPacket, n2, this.packetLength, this.packetLengthType);
        n2 = MediaPacket.writeByteWithLengthType(this.newPacket, n2, this.sequence, this.sequenceLengthType);
        n2 = MediaPacket.writeByteWithLengthType(this.newPacket, n2, this.paddingLength, this.paddingLengthType);
        for (n = 0; n < 4; ++n) {
            this.newPacket[n2 + n] = (byte)(this.sendTime >> 8 * n);
        }
        this.newPacket[n2 + 4] = (byte)this.duration;
        this.newPacket[n2 + 5] = (byte)(this.duration >> 8);
        n2 += 6;
        if (this.multiplePayload) {
            this.newPacket[n2] = (byte)(this.numberOfPayloads + (this.payloadLengthType << 6));
            ++n2;
            for (n = 0; n < this.payloadArrayList.size(); ++n) {
                Payload payload = (Payload)this.payloadArrayList.get(n);
                System.arraycopy(payload.getByteArray(), 0, this.newPacket, n2, payload.getObjectSize());
                n2 += payload.getObjectSize();
            }
        } else {
            Payload payload = (Payload)this.payloadArrayList.get(0);
            System.arraycopy(payload.getByteArray(), 0, this.newPacket, n2, payload.getObjectSize());
            n2 += payload.getObjectSize();
        }
        this.caluculatedPaddingLength = this.newPacket.length - n2;
        for (int i = 0; i < this.caluculatedPaddingLength; ++i) {
            this.newPacket[n2 + i] = 0;
        }
        return this.newPacket;
    }

    byte[] updatePacketArray() {
        int n;
        this.newPacket[3] = (byte)((this.booleanToInt(this.hasErrorCorrection2) << 7) + (this.packetLengthType << 5) + (this.paddingLengthType << 3) + (this.sequenceLengthType << 1) + (this.booleanToInt(this.multiplePayload) & 1));
        int n2 = 5;
        n2 = MediaPacket.writeByteWithLengthType(this.newPacket, n2, this.paddingLength, this.paddingLengthType);
        this.newPacket[n2] = (byte)this.sendTime;
        this.newPacket[n2 + 1] = (byte)(this.sendTime >> 8);
        this.newPacket[n2 + 2] = (byte)(this.sendTime >> 16);
        this.newPacket[n2 + 3] = (byte)(this.sendTime >> 24);
        this.newPacket[n2 + 4] = (byte)this.duration;
        this.newPacket[n2 + 5] = (byte)(this.duration >> 8);
        n2 += 6;
        if (this.multiplePayload) {
            this.newPacket[n2] = (byte)(this.numberOfPayloads + (this.payloadLengthType << 6));
            ++n2;
            for (n = 0; n < this.payloadArrayList.size(); ++n) {
                Payload payload = (Payload)this.payloadArrayList.get(n);
                long l = payload.getPresentationTime();
                payload.writePayload(this.newPacket, n2);
                n2 += payload.getObjectSize();
            }
        } else if (this.payloadArrayList.size() > 0) {
            Payload payload = (Payload)this.payloadArrayList.get(0);
            payload.writePayload(this.newPacket, n2);
            n2 += payload.getObjectSize();
        }
        this.caluculatedPaddingLength = this.newPacket.length - n2;
        for (n = 0; n < this.caluculatedPaddingLength; ++n) {
            this.newPacket[n2 + n] = 0;
        }
        n2 = MediaPacket.writeByteWithLengthType(this.newPacket, 5, this.caluculatedPaddingLength, this.paddingLengthType);
        return this.newPacket;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getByteArray();
        stringBuffer.append("\t -------packetCounter : " + this.packetCounter + "-----\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, 0, 3);
        stringBuffer.append("\t Error  Correction\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, 3, 1);
        stringBuffer.append("\t Length Type Flags          multiple : " + this.multiplePayload + "        paddingLengthType : " + this.paddingLengthType + "\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, 4, 1);
        stringBuffer.append("\t Property Flags\n");
        int n = 5;
        AsfHeader.appendHexString(stringBuffer, this.newPacket, n, MediaPacket.decodeLengthType(this.packetLengthType));
        stringBuffer.append("\t packetLength : " + this.packetLength + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, n += MediaPacket.decodeLengthType(this.packetLengthType), MediaPacket.decodeLengthType(this.sequenceLengthType));
        stringBuffer.append("\t sequence Length : " + this.sequence + "\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, n += MediaPacket.decodeLengthType(this.sequenceLengthType), MediaPacket.decodeLengthType(this.paddingLengthType));
        stringBuffer.append("\t Padding Length : " + this.paddingLength + " bytes     caluculatedPaddingLength : " + this.caluculatedPaddingLength + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, n += MediaPacket.decodeLengthType(this.paddingLengthType), 4);
        stringBuffer.append("\t Send Time : " + this.sendTime + " millisec\n");
        AsfHeader.appendHexString(stringBuffer, this.newPacket, n + 4, 2);
        stringBuffer.append("\t Duration : " + this.duration + " millisec\n");
        n += 6;
        if (this.multiplePayload) {
            AsfHeader.appendHexString(stringBuffer, this.newPacket, n, 1);
            stringBuffer.append("\t Payload Flags    Payload Length Type : " + this.payloadLengthType + "     Number of Payload : " + this.numberOfPayloads + "\n");
        }
        stringBuffer.append("\n");
        for (int i = 0; i < this.payloadArrayList.size(); ++i) {
            Payload payload = (Payload)this.payloadArrayList.get(i);
            long l = payload.getPresentationTime() - this.sendTime;
            stringBuffer.append("\tdiffer   " + l + "\n");
            stringBuffer.append(payload.dumpText());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void setMediaPacketSize(int n) {
        this.objectSize = n;
        this.reset();
        this.newPacket = new byte[this.objectSize];
    }

    void reset() {
        this.payloadArrayList.clear();
        this.numberOfPayloads = 0;
        this.packetIsVacant = true;
        this.multiplePayload = false;
        this.setPaddingLengthType();
    }

    void setPaddingLengthType(int n) {
        this.paddingLengthType = n;
    }

    private void setPaddingLengthType() {
        int n = this.restLength();
        this.paddingLengthType = n == 0 ? 0 : (n < 255 ? 1 : (n < 65535 ? 2 : 4));
    }

    void setMultiple(boolean bl) {
        this.multiplePayload = bl;
        for (int i = 0; i < this.payloadArrayList.size(); ++i) {
            Payload payload = (Payload)this.payloadArrayList.get(i);
            payload.setMultiple(bl);
        }
    }

    int getHeaderSize() {
        return 11 + this.booleanToInt(this.multiplePayload) + MediaPacket.decodeLengthType(this.packetLengthType) + MediaPacket.decodeLengthType(this.paddingLengthType);
    }

    public ArrayList getPayloadList() {
        return this.payloadArrayList;
    }

    public long getFirstPresentationTime() {
        Payload payload = (Payload)this.payloadArrayList.get(0);
        return payload.getPresentationTime();
    }

    int getAllPayloadsSize() {
        int n = 0;
        for (int i = 0; i < this.payloadArrayList.size(); ++i) {
            Payload payload = (Payload)this.payloadArrayList.get(i);
            n += payload.getObjectSize();
        }
        return n;
    }

    int restLength() {
        return this.objectSize - this.getHeaderSize() - this.getAllPayloadsSize();
    }

    void addPayload(Payload payload) {
        this.payloadArrayList.add(payload);
        this.numberOfPayloads = this.payloadArrayList.size();
        if (this.packetIsVacant) {
            this.regurateDuration(payload.getPresentationTime());
        }
        this.multiplePayload = this.numberOfPayloads > 1;
        this.setPaddingLengthType();
        this.packetIsVacant = false;
    }

    void updateSendTime() {
        this.sendTime += this.duration;
    }

    private void regurateDuration(long l) {
        this.duration = this.initialDuration * (l - this.sendTime) / this.preroll;
        if (this.duration < 0L) {
            this.duration = 0L;
        }
    }

    public boolean hasCompressedPayload() {
        for (int i = 0; i < this.payloadArrayList.size(); ++i) {
            Payload payload = (Payload)this.payloadArrayList.get(i);
            if (!payload.isCompressed()) continue;
            return true;
        }
        return false;
    }

    public byte[] getPacketBuffer() {
        return this.packet;
    }

    int getObjectSize() {
        return this.objectSize;
    }

    boolean isMultiple() {
        return this.multiplePayload;
    }

    boolean isVacant() {
        return this.packetIsVacant;
    }

    int getPayloadLengthType() {
        return this.payloadLengthType;
    }

    int getPacketCounter() {
        return this.packetCounter;
    }

    void setOffsetTime(long l) {
        this.sendTime -= l;
        this.sendTimeOffset = l;
    }

    void setErrorCorrection(boolean bl) {
        this.hasErrorCorrection = bl;
    }

    void setErrorCorrectionLengthType(int n) {
        this.errorCorrectionLengthType = n;
    }

    void setOpaqueData(boolean bl) {
        this.hasOpaqueData = bl;
    }

    void setErrorCorrectionDataLength(int n) {
        this.errorCorrectionDataLength = n;
    }

    void setErrorCorrectionData(byte[] byArray) {
        this.errorCorrectionData = byArray;
    }

    void setErrorCorrectionInLengthTypeFlags(boolean bl) {
        this.hasErrorCorrection2 = bl;
    }

    void setPacketLengthType(int n) {
        this.packetLengthType = n;
    }

    void setSequenceLengthType(int n) {
        this.sequenceLengthType = n;
    }

    int getPacketLengthType() {
        return this.packetLengthType;
    }

    int getPaddingLengthType() {
        return this.paddingLengthType;
    }

    int getSequenceLengthType() {
        return this.sequenceLengthType;
    }

    boolean getMultiple() {
        return this.multiplePayload;
    }

    void setStreamNumberLengthType(int n) {
        this.streamNumberLengthType = n;
    }

    void setMediaObjectNumberLengthType(int n) {
        this.mediaObjectNumberLengthType = n;
    }

    void setOffsetOrPresentationTimeLengthType(int n) {
        this.offsetOrPresentationTimeLengthType = n;
    }

    void setReplicatedDataLengthType(int n) {
        this.replicatedDataLengthType = n;
    }

    int getStreamNumberLengthType() {
        return this.streamNumberLengthType;
    }

    int getMediaObjectNumberLengthType() {
        return this.mediaObjectNumberLengthType;
    }

    int getOffsetOrPresentationTimeLengthType() {
        return this.offsetOrPresentationTimeLengthType;
    }

    int getReplicatedDataLengthType() {
        return this.replicatedDataLengthType;
    }

    int getPacketLength() {
        return this.packetLength;
    }

    int getPaddingLength() {
        return this.paddingLength;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public long getDuration() {
        return this.duration;
    }

    void setPacketLength(int n) {
        this.packetLength = n;
    }

    void setSequence(int n) {
        this.sequence = n;
    }

    void setPaddingLength(int n) {
        this.paddingLength = n;
    }

    void setSendTime(long l) {
        this.sendTime = l;
    }

    void setDuration(int n) {
        this.initialDuration = this.duration = (long)n;
    }

    void setPreroll(int n) {
        this.preroll = n;
    }

    int getNumberOfPayloads() {
        return this.numberOfPayloads;
    }

    void setNumberOfPayloads(int n) {
        this.numberOfPayloads = n;
    }

    void setPayloadLengthType(int n) {
        this.payloadLengthType = n;
    }

    private int readLength(byte[] byArray, int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return byArray[n2] & 0xFF;
        }
        if (n == 2) {
            return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
        }
        if (n == 3) {
            return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 24);
        }
        return 0;
    }

    static int decodeLengthType(int n) {
        if (n < 3 && n > -1) {
            return n;
        }
        if (n == 3) {
            return 4;
        }
        return 0;
    }

    private int booleanToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    static int writeByteWithLengthType(byte[] byArray, int n, int n2, int n3) {
        if (n3 == 1) {
            byArray[n] = (byte)n2;
            ++n;
        } else if (n3 == 2) {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
            n += 2;
        } else if (n3 == 3) {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)(n2 >> 16);
            byArray[n + 3] = (byte)(n2 >> 24);
            n += 4;
        }
        return n;
    }
}

