/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;
import asf.AsfHeaderObject;

class Padding
extends AsfHeaderObject {
    private int objectSize;

    public Padding() {
        this.objectSize = 24;
    }

    public Padding(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
    }

    int getObjectSize() {
        return this.objectSize;
    }

    void setObjectSize(int n) {
        this.objectSize = n;
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        if (this.objectSize > 24) {
            for (int i = 24; i < this.objectSize - 16 - 8; ++i) {
                byArray[i] = 0;
            }
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Padding_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize : " + this.objectSize + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

