/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;
import asf.MediaObject;
import asf.MediaPacket;
import java.util.ArrayList;

public class Payload {
    private int streamNumber;
    private boolean keyFrame;
    private int mediaObjectNumber;
    private long offsetOrPresentationTime;
    private int replicatedLength;
    private boolean compressed;
    private int rep_mediaObjectSize;
    private long rep_PresentationTime;
    private byte[] replicatedData;
    private int presentationTimeDelta;
    private int payloadDataLength;
    private int payloadLengthType;
    private int mediaObjectNumberLengthType;
    private int offsetOrPresentationTimeLengthType;
    private int replicatedDataLengthType;
    private int subPayloadCounts;
    private byte[] dataArrayRef;
    private int offset;
    private int dataOffset;
    private boolean multiple;
    private int objectSize;
    private MediaPacket mp;

    public Payload(MediaPacket mediaPacket) {
        this.mediaObjectNumberLengthType = mediaPacket.getMediaObjectNumberLengthType();
        this.offsetOrPresentationTimeLengthType = mediaPacket.getOffsetOrPresentationTimeLengthType();
        this.replicatedDataLengthType = mediaPacket.getReplicatedDataLengthType();
        this.replicatedLength = 8;
    }

    public Payload(byte[] byArray, int n, MediaPacket mediaPacket) {
        this.dataArrayRef = byArray;
        this.offset = n;
        this.mp = mediaPacket;
        this.payloadLengthType = mediaPacket.getPayloadLengthType();
        this.mediaObjectNumberLengthType = mediaPacket.getMediaObjectNumberLengthType();
        this.offsetOrPresentationTimeLengthType = mediaPacket.getOffsetOrPresentationTimeLengthType();
        this.replicatedDataLengthType = mediaPacket.getReplicatedDataLengthType();
        this.multiple = mediaPacket.isMultiple();
        this.streamNumber = this.dataArrayRef[this.offset] & 0x7F;
        if ((this.dataArrayRef[this.offset] & 0x80) == 128) {
            this.keyFrame = true;
        }
        ++this.offset;
        this.mediaObjectNumber = this.readLength(mediaPacket.getMediaObjectNumberLengthType());
        this.offsetOrPresentationTime = this.readLength(mediaPacket.getOffsetOrPresentationTimeLengthType());
        this.replicatedLength = this.readLength(mediaPacket.getReplicatedDataLengthType());
        if (this.replicatedLength >= 8) {
            this.rep_mediaObjectSize = (this.dataArrayRef[this.offset] & 0xFF) + ((this.dataArrayRef[this.offset + 1] & 0xFF) << 8) + ((this.dataArrayRef[this.offset + 2] & 0xFF) << 16) + ((this.dataArrayRef[this.offset + 3] & 0xFF) << 24);
            this.rep_PresentationTime = ((long)this.dataArrayRef[this.offset + 4] & 0xFFL) + (((long)this.dataArrayRef[this.offset + 5] & 0xFFL) << 8) + (((long)this.dataArrayRef[this.offset + 6] & 0xFFL) << 16) + (((long)this.dataArrayRef[this.offset + 7] & 0xFFL) << 24);
            if (this.replicatedLength > 8) {
                this.replicatedData = new byte[this.replicatedLength - 8];
                for (int i = 0; i < this.replicatedLength - 8; ++i) {
                    this.replicatedData[i] = this.dataArrayRef[this.offset + 8 + i];
                }
            }
            this.offset += this.replicatedLength;
            this.payloadDataLength = this.readLength(this.payloadLengthType);
            if (!this.multiple) {
                this.payloadDataLength = mediaPacket.getPacketLengthType() != 0 ? mediaPacket.getPacketLength() - this.offset : (this.rep_mediaObjectSize - (int)this.offsetOrPresentationTime <= this.dataArrayRef.length - this.offset ? this.rep_mediaObjectSize - (int)this.offsetOrPresentationTime - mediaPacket.getPaddingLength() : this.dataArrayRef.length - this.offset - mediaPacket.getPaddingLength());
            }
        } else if (this.replicatedLength == 1) {
            System.out.println("compressed payload : packet count : " + mediaPacket.getPacketCounter());
            this.compressed = true;
            this.presentationTimeDelta = this.dataArrayRef[this.offset] & 0xFF;
            ++this.offset;
            this.payloadDataLength = this.readLength(this.payloadLengthType);
            if (!this.multiple) {
                this.payloadDataLength = mediaPacket.getPacketLengthType() != 0 ? mediaPacket.getPacketLength() - this.offset : this.dataArrayRef.length - this.offset - mediaPacket.getPaddingLength();
            }
            this.subPayloadCounts = this.countSubPayload(this.dataArrayRef, this.offset, this.payloadDataLength);
        } else if (this.replicatedLength == 0) {
            this.payloadDataLength = this.readLength(this.payloadLengthType);
            if (!this.multiple) {
                this.payloadDataLength = mediaPacket.getPacketLengthType() != 0 ? mediaPacket.getPacketLength() - this.offset : this.dataArrayRef.length - this.offset - mediaPacket.getPaddingLength();
            }
        } else {
            System.out.println("Replicated Data Length value is invalid : " + this.replicatedLength);
        }
        this.dataOffset = this.offset;
        this.objectSize = this.dataOffset - n + this.payloadDataLength;
    }

    private int readLength(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = 0;
        } else if (n == 1) {
            n2 = this.dataArrayRef[this.offset] & 0xFF;
            ++this.offset;
        } else if (n == 2) {
            n2 = (this.dataArrayRef[this.offset] & 0xFF) + ((this.dataArrayRef[this.offset + 1] & 0xFF) << 8);
            this.offset += 2;
        } else if (n == 3) {
            n2 = (this.dataArrayRef[this.offset] & 0xFF) + ((this.dataArrayRef[this.offset + 1] & 0xFF) << 8) + ((this.dataArrayRef[this.offset + 2] & 0xFF) << 16) + ((this.dataArrayRef[this.offset + 3] & 0xFF) << 24);
            this.offset += 4;
        } else {
            n2 = 0;
        }
        return n2;
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        this.writePayload(byArray, 0);
        return byArray;
    }

    void writePayload(byte[] byArray, int n) {
        int n2 = n;
        byArray[n2] = this.keyFrame ? (byte)(this.streamNumber + 128) : (byte)this.streamNumber;
        ++n2;
        n2 = MediaPacket.writeByteWithLengthType(byArray, n2, this.mediaObjectNumber, this.mediaObjectNumberLengthType);
        n2 = MediaPacket.writeByteWithLengthType(byArray, n2, (int)this.offsetOrPresentationTime, this.offsetOrPresentationTimeLengthType);
        n2 = MediaPacket.writeByteWithLengthType(byArray, n2, this.replicatedLength, this.replicatedDataLengthType);
        if (this.compressed) {
            byArray[n2] = (byte)this.presentationTimeDelta;
            System.arraycopy(this.dataArrayRef, this.dataOffset, byArray, 8, this.payloadDataLength);
        } else {
            byArray[n2] = (byte)this.rep_mediaObjectSize;
            byArray[n2 + 1] = (byte)(this.rep_mediaObjectSize >> 8);
            byArray[n2 + 2] = (byte)(this.rep_mediaObjectSize >> 16);
            byArray[n2 + 3] = (byte)(this.rep_mediaObjectSize >> 24);
            byArray[n2 += 4] = (byte)this.rep_PresentationTime;
            byArray[n2 + 1] = (byte)(this.rep_PresentationTime >> 8);
            byArray[n2 + 2] = (byte)(this.rep_PresentationTime >> 16);
            byArray[n2 + 3] = (byte)(this.rep_PresentationTime >> 24);
            n2 += 4;
            if (this.replicatedLength > 8) {
                for (int i = 0; i < this.replicatedLength - 8; ++i) {
                    byArray[n2 + i] = this.replicatedData[i];
                }
            }
            n2 += this.replicatedLength - 8;
            n2 = MediaPacket.writeByteWithLengthType(byArray, n2, this.payloadDataLength, this.payloadLengthType);
            System.arraycopy(this.dataArrayRef, this.dataOffset, byArray, n2, this.payloadDataLength);
        }
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        stringBuffer.append("     ");
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 1);
        stringBuffer.append("\t      streamNumber : " + this.streamNumber + "      keyFrame : " + this.keyFrame + "\n");
        int n = 1;
        stringBuffer.append("     ");
        AsfHeader.appendHexString(stringBuffer, byArray, n, MediaPacket.decodeLengthType(this.mp.getMediaObjectNumberLengthType()));
        stringBuffer.append("\t      mediaObjectNumber : " + this.mediaObjectNumber + "\n");
        stringBuffer.append("     ");
        AsfHeader.appendHexString(stringBuffer, byArray, n += MediaPacket.decodeLengthType(this.mp.getMediaObjectNumberLengthType()), MediaPacket.decodeLengthType(this.mp.getOffsetOrPresentationTimeLengthType()));
        if (this.compressed) {
            stringBuffer.append("     offsetOrPresentationTime : " + this.offsetOrPresentationTime + " millisec\n");
        } else {
            stringBuffer.append("     offsetOrPresentationTime : " + this.offsetOrPresentationTime + "\n");
        }
        stringBuffer.append("     ");
        AsfHeader.appendHexString(stringBuffer, byArray, n += MediaPacket.decodeLengthType(this.mp.getOffsetOrPresentationTimeLengthType()), MediaPacket.decodeLengthType(this.mp.getReplicatedDataLengthType()));
        stringBuffer.append("\t      replicatedLength : " + this.replicatedLength + "\n");
        stringBuffer.append("     ");
        AsfHeader.appendHexString(stringBuffer, byArray, n += MediaPacket.decodeLengthType(this.mp.getReplicatedDataLengthType()), this.replicatedLength);
        if (this.compressed) {
            stringBuffer.append("\t      presentationTimeDelta : " + this.presentationTimeDelta + " millisec\n");
        } else {
            stringBuffer.append("\t      rep_mediaObjectSize : " + this.rep_mediaObjectSize + " bytes     rep_PresentationTime : " + this.rep_PresentationTime + " millisec\n");
        }
        stringBuffer.append("     ");
        AsfHeader.appendHexString(stringBuffer, byArray, n += this.replicatedLength, MediaPacket.decodeLengthType(this.payloadLengthType));
        stringBuffer.append("\t      payloadDataLength : " + this.payloadDataLength + " bytes\n");
        if (this.compressed) {
            stringBuffer.append("     ");
            stringBuffer.append("\t      compressed payload      subPayloadCounts : " + this.subPayloadCounts + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private int countSubPayload(byte[] byArray, int n, int n2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            int n5 = byArray[n] & 0xFF;
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n + 1, byArray2, 0, n5);
            arrayList.add(byArray2);
            n += n5 + 1;
            n3 += n5 + 1;
            ++n4;
        }
        return arrayList.size();
    }

    int getObjectSize() {
        return this.getHeaderSize() + this.payloadDataLength;
    }

    int getHeaderSize() {
        if (this.compressed) {
            return 8 + MediaPacket.decodeLengthType(this.payloadLengthType);
        }
        return 7 + this.replicatedLength + MediaPacket.decodeLengthType(this.payloadLengthType);
    }

    int getDataSize() {
        return this.payloadDataLength;
    }

    int getStreamNumber() {
        return this.streamNumber;
    }

    boolean isKeyFrame() {
        return this.keyFrame;
    }

    int getMediaObjectNumber() {
        return this.mediaObjectNumber;
    }

    boolean isCompressed() {
        return this.compressed;
    }

    public long getPresentationTime() {
        if (this.compressed) {
            return this.offsetOrPresentationTime;
        }
        return this.rep_PresentationTime;
    }

    long getOffsetOrPresentationTime() {
        return this.offsetOrPresentationTime;
    }

    long getRep_PresentationTime() {
        return this.rep_PresentationTime;
    }

    int getPresentationTimeDelta() {
        return this.presentationTimeDelta;
    }

    int getSubPayloadCounts() {
        return this.subPayloadCounts;
    }

    void setStreamNumber(int n) {
        this.streamNumber = n;
    }

    void setKeyFrame(boolean bl) {
        this.keyFrame = bl;
    }

    void setMediaObjectNumber(int n) {
        this.mediaObjectNumber = n;
    }

    void setOffsetTime(long l) {
        if (this.compressed) {
            this.offsetOrPresentationTime -= l;
        } else {
            this.rep_PresentationTime -= l;
        }
    }

    void setPresentationTime(long l) {
        if (this.compressed) {
            this.offsetOrPresentationTime = l;
        } else {
            this.rep_PresentationTime = l;
        }
    }

    void setDataArray(byte[] byArray, int n, int n2) {
        this.dataArrayRef = null;
        this.dataArrayRef = byArray;
        this.dataOffset = n;
        this.payloadDataLength = n2;
        this.objectSize = 15 + MediaPacket.decodeLengthType(this.payloadLengthType) + this.payloadDataLength;
    }

    void setMultiple(boolean bl) {
        this.multiple = bl;
        this.payloadLengthType = bl ? 2 : 0;
        this.objectSize = 15 + MediaPacket.decodeLengthType(this.payloadLengthType) + this.payloadDataLength;
    }

    void setPayloadLengthType(int n) {
        this.payloadLengthType = n;
    }

    void setValueFromMediaObject(MediaObject mediaObject) {
        this.streamNumber = mediaObject.getStreamNumber();
        this.keyFrame = mediaObject.isKeyFrame();
        this.mediaObjectNumber = mediaObject.getMediaObjectNumber();
        this.offsetOrPresentationTime = mediaObject.getCurrentDataAddress();
        this.rep_mediaObjectSize = mediaObject.getDataSize();
        this.rep_PresentationTime = mediaObject.getPresentationTime();
    }
}

