/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;

class StreamBitrateProperties
extends AsfHeaderObject {
    private int objectSize;
    private int bitrateRecordsCount;
    private int[] streamNumber;
    private int[] averageBitrate;

    public StreamBitrateProperties(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.bitrateRecordsCount = (byArray[n + 24] & 0xFF) + ((byArray[n + 25] & 0xFF) << 8);
        this.streamNumber = new int[this.bitrateRecordsCount];
        this.averageBitrate = new int[this.bitrateRecordsCount];
        for (int i = 0; i < this.bitrateRecordsCount; ++i) {
            this.streamNumber[i] = (byArray[n + 26 + i * 6] & 0xFF) + ((byArray[n + 27 + i * 6] & 0x7F) << 8);
            this.averageBitrate[i] = (byArray[n + 28 + i * 6] & 0xFF) + ((byArray[n + 29 + i * 6] & 0xFF) << 8) + ((byArray[n + 30 + i * 6] & 0xFF) << 16) + ((byArray[n + 31 + i * 6] & 0xFF) << 24);
        }
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Stream_Bitrate_Properties_Object, 0, byArray, 0, 16);
        for (n = 0; n < 4; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[20 + n] = 0;
        }
        byArray[24] = (byte)this.bitrateRecordsCount;
        byArray[25] = (byte)(this.bitrateRecordsCount >> 8);
        for (n = 0; n < this.bitrateRecordsCount; ++n) {
            byArray[26 + n * 6] = (byte)this.streamNumber[n];
            byArray[26 + n * 6 + 1] = (byte)(this.streamNumber[n] >> 8);
            byArray[26 + n * 6 + 2] = (byte)this.averageBitrate[n];
            byArray[26 + n * 6 + 3] = (byte)(this.averageBitrate[n] >> 8);
            byArray[26 + n * 6 + 4] = (byte)(this.averageBitrate[n] >> 16);
            byArray[26 + n * 6 + 5] = (byte)(this.averageBitrate[n] >> 24);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Stream_Bitrate_Properties_Object GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 2);
        stringBuffer.append("\t Bitrate Records Count : " + this.bitrateRecordsCount + "\n");
        for (int i = 0; i < this.bitrateRecordsCount; ++i) {
            AsfHeader.appendHexString(stringBuffer, byArray, 26 + i * 6, 2);
            stringBuffer.append("\t Flags ( Stream Number  7bit   Reserved 1bit ) : " + this.streamNumber[i] + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 26 + i * 6 + 2, 4);
            stringBuffer.append("\t Average Bitrate : " + this.averageBitrate[i] + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    int getObjectSize() {
        return this.objectSize;
    }

    int getBitrateRecordsCount() {
        return this.bitrateRecordsCount;
    }

    int[] getStreamNumber() {
        return this.streamNumber;
    }

    int[] getAverageBitrate() {
        return this.averageBitrate;
    }
}

