/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;
import asf.AsfStream;
import asf.BitmapInfoHeader;
import asf.WaveFormatEX;

class TypeSpecificData {
    private String type;
    private int objectSize;
    private int encodedImageWidth;
    private int encodedImageHeight;
    private int reservedFlag;
    private int formatDataSize;
    private BitmapInfoHeader bitmapInfoHeader;
    private WaveFormatEX waveFormatEX;

    public TypeSpecificData(AsfStream asfStream, int n, String string) {
        this.type = string;
        this.objectSize = n;
        if (string.equals("video")) {
            this.objectSize = 55;
            this.encodedImageWidth = asfStream.getWidth();
            this.encodedImageHeight = asfStream.getHeight();
            this.reservedFlag = 2;
            this.formatDataSize = 44;
            this.bitmapInfoHeader = new BitmapInfoHeader(asfStream, this.formatDataSize);
        } else if (string.equals("audio")) {
            // empty if block
        }
    }

    public TypeSpecificData(byte[] byArray, int n, int n2, String string) {
        this.type = string;
        this.objectSize = n2;
        if (string.equals("video")) {
            this.encodedImageWidth = (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
            this.encodedImageHeight = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
            this.reservedFlag = byArray[n + 8] & 0xFF;
            this.formatDataSize = (byArray[n + 9] & 0xFF) + ((byArray[n + 10] & 0xFF) << 8);
            if (this.formatDataSize > 0) {
                this.bitmapInfoHeader = new BitmapInfoHeader(byArray, n + 11, this.formatDataSize);
            }
        } else if (string.equals("audio") && n2 > 0) {
            this.waveFormatEX = new WaveFormatEX(byArray, n, n2);
        }
    }

    String getCodecString() {
        String string = "";
        if (this.type.equals("video")) {
            string = this.bitmapInfoHeader.getCodecString();
        } else if (this.type.equals("audio")) {
            string = this.waveFormatEX.getCodecString();
        }
        return string;
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        if (this.type.equals("video")) {
            byArray[0] = (byte)this.encodedImageWidth;
            byArray[1] = (byte)(this.encodedImageWidth >> 8);
            byArray[2] = (byte)(this.encodedImageWidth >> 16);
            byArray[3] = (byte)(this.encodedImageWidth >> 24);
            byArray[4] = (byte)this.encodedImageHeight;
            byArray[5] = (byte)(this.encodedImageHeight >> 8);
            byArray[6] = (byte)(this.encodedImageHeight >> 16);
            byArray[7] = (byte)(this.encodedImageHeight >> 24);
            byArray[8] = (byte)this.reservedFlag;
            byArray[9] = (byte)this.formatDataSize;
            byArray[10] = (byte)(this.formatDataSize >> 8);
            if (this.formatDataSize > 0) {
                System.arraycopy(this.bitmapInfoHeader.getByteArray(), 0, byArray, 11, this.formatDataSize);
            }
        } else if (this.type.equals("audio")) {
            System.arraycopy(this.waveFormatEX.getByteArray(), 0, byArray, 0, this.objectSize);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        if (this.type.equals("video")) {
            AsfHeader.appendHexString(stringBuffer, byArray, 0, 4);
            stringBuffer.append("\t\t Encoded Image Width : " + this.encodedImageWidth + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 4, 4);
            stringBuffer.append("\t\t Encoded Image Height : " + this.encodedImageHeight + "\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 8, 1);
            stringBuffer.append("\t\t Reserved Flags\n");
            AsfHeader.appendHexString(stringBuffer, byArray, 9, 2);
            stringBuffer.append("\t\t Format Data Size : " + this.formatDataSize + "\n");
            if (this.formatDataSize > 0) {
                stringBuffer.append(this.bitmapInfoHeader.dumpText());
            }
        } else if (this.type.equals("audio")) {
            stringBuffer.append(this.waveFormatEX.dumpText());
        }
        return stringBuffer.toString();
    }

    void setBitmapInfoHeader(BitmapInfoHeader bitmapInfoHeader) {
        this.bitmapInfoHeader = bitmapInfoHeader;
    }

    int getObjectSize() {
        return this.objectSize;
    }
}

