/*
 * Decompiled with CFR 0.152.
 */
package avi;

import avi.AviData;
import avi.AviHeader;
import avi.AviIndex;
import java.io.File;
import java.io.IOException;

public class AviFile {
    private AviHeader aviHeader;
    private boolean isValidAvi;
    private AviData aviData;
    private AviIndex aviIndex;
    private File sourceFile;

    public AviFile(File file) {
        this.sourceFile = file;
        this.aviHeader = new AviHeader(this.sourceFile);
        this.isValidAvi = this.aviHeader.parseHeader();
        this.aviData = new AviData(this);
        try {
            this.aviIndex = new AviIndex(this);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public boolean isValidAviFile() {
        return this.isValidAvi;
    }

    public String getVideoCodec() {
        return this.aviHeader.getVideoCodec();
    }

    public String getAudioCodec() {
        return this.aviHeader.getAudioCodec();
    }

    public long getMicroSecPerFrame() {
        return this.aviHeader.getMicroSecPerFrame();
    }

    public int getWidth() {
        return this.aviHeader.getVideoWidth();
    }

    public int getHeight() {
        return this.aviHeader.getVideoHeight();
    }

    public int getHeaderSize() {
        return this.aviHeader.getHeaderSize();
    }

    public long getDataSize() {
        return this.aviData.getDataSize();
    }

    public File getFile() {
        return this.sourceFile;
    }

    public void closeFile() throws IOException {
        if (this.sourceFile != null) {
            this.aviData.close();
            this.sourceFile = null;
        }
    }

    public byte[] getBitmapInfoHeaderArray() {
        return this.aviHeader.getBitmapInfoHeaderArray();
    }

    public long getVideoDataRate() {
        long l = (long)this.aviHeader.getAudioDataRate() * this.aviHeader.getPlayTimeMilliSec() / 1000L;
        long l2 = this.aviHeader.getFileSize() - (long)this.aviHeader.getHeaderSize() - l;
        return 1000000L * l2 * 8L / (this.aviHeader.getMicroSecPerFrame() * (long)this.aviHeader.getVideoFrameCount());
    }

    public int getVideoFrameCount() {
        return this.aviHeader.getVideoFrameCount();
    }

    public void prepareData() {
        this.aviData.prepareData();
    }

    public boolean hasNextChunk() {
        return this.aviData.hasNextChunk();
    }

    public int nextChunkSize() {
        return this.aviData.nextChunkSize();
    }

    public int nextChunkType() {
        int n = this.aviData.nextChunkType();
        if (this.aviIndex.hasIndex()) {
            long l;
            this.aviIndex.nextIndex();
            if (n == 1 || n == 4) {
                return n;
            }
            long l2 = this.aviIndex.getDataOffset();
            if (l2 == (l = this.aviData.getCurrentDataOffset()) && this.aviIndex.isKeyFrame()) {
                n = 2;
            }
        }
        return n;
    }

    public byte[] getNextChunkArray() {
        return this.aviData.getNextChunkArray();
    }

    public void skipChunkData() {
        this.aviData.skipChunkData();
    }

    public int read() throws IOException {
        return this.aviData.read();
    }
}

