/*
 * Decompiled with CFR 0.152.
 */
package wmv3server;

import asf.MediaPlayer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.movies.Movie;

class MP3Player
extends JPanel
implements MediaPlayer,
ActionListener,
ChangeListener {
    private Movie movie;
    private OpenMovieFile openFile;
    private JSlider volumeSlider;

    public MP3Player() {
        JLabel jLabel = new JLabel("adjust audio");
        this.add(jLabel);
        JButton jButton = new JButton("-");
        jButton.setActionCommand("decre");
        jButton.addActionListener(this);
        this.add(jButton);
        JButton jButton2 = new JButton("+");
        jButton2.setActionCommand("incre");
        jButton2.addActionListener(this);
        this.add(jButton2);
        JLabel jLabel2 = new JLabel("             ");
        this.add(jLabel2);
        JLabel jLabel3 = new JLabel("Volume");
        this.add(jLabel3);
        this.volumeSlider = new JSlider();
        this.volumeSlider.addChangeListener(this);
        this.add(this.volumeSlider);
        this.volumeSlider.setMinimum(0);
        this.volumeSlider.setMaximum(100);
        this.volumeSlider.setValue(80);
        try {
            QTSession.open();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            QTSession.close();
            System.exit(-1);
        }
    }

    void setMP3File(File file) {
        try {
            this.openFile = OpenMovieFile.asRead((QTFile)new QTFile(file));
            this.movie = Movie.fromFile((OpenMovieFile)this.openFile);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            QTSession.close();
            System.exit(-1);
        }
        this.setVolume();
    }

    void disposeMovie() {
        try {
            if (this.openFile != null) {
                this.openFile.close();
                this.openFile = null;
            }
            if (this.movie != null) {
                this.movie.disposeQTObject();
                this.movie = null;
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            QTSession.close();
            System.exit(-1);
        }
    }

    public void start() {
        try {
            if (this.movie != null) {
                this.movie.start();
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.movie != null) {
                this.movie.stop();
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void start(double d) {
        try {
            if (this.movie != null) {
                int n = this.movie.getTimeScale();
                long l = (long)(d * (double)n);
                this.movie.setTime(new TimeRecord(n, l));
                this.movie.start();
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void setTime(double d) {
        try {
            if (this.movie != null) {
                int n = this.movie.getTimeScale();
                long l = (long)(d * (double)n);
                this.movie.setTime(new TimeRecord(n, l));
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public double getTime() {
        double d = 0.0;
        try {
            int n = this.movie.getTime();
            int n2 = this.movie.getTimeScale();
            d = n / n2;
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
        return d;
    }

    public void adjustTime(int n) {
        try {
            this.movie.setTimeValue(this.movie.getTime() + n);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "incre") {
            this.adjustTime(30);
        } else if (actionEvent.getActionCommand() == "decre") {
            this.adjustTime(-25);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setVolume();
    }

    public void setVolume() {
        try {
            float f = (float)this.volumeSlider.getValue() / 100.0f;
            if (this.movie != null) {
                this.movie.setVolume(f);
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public int getVolumeSliderValue() {
        return this.volumeSlider.getValue();
    }

    public void setVolumeSliderValue(int n) {
        this.volumeSlider.setValue(n);
    }
}

