/*
 * Decompiled with CFR 0.152.
 */
package wmv3server;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import wmv3server.MP3Player;
import wmv3server.WMV3Server;

class WMV3ServerGUI
extends JFrame
implements ActionListener {
    private WMV3Server controll;
    private JLabel fileLabel;
    private JButton openButton;
    private JButton createAsfButton;
    private JButton stopButton;
    private JMenuItem open;
    private JMenuItem convertToAsf;
    private JLabel videoCodec;
    private JLabel audioCodec;
    private JProgressBar asfCreationBar;
    private JLabel messageLabel;
    private Graphics g;
    private FileDialog fd;
    private MP3Player mp3Player;

    public WMV3ServerGUI(WMV3Server wMV3Server, MP3Player mP3Player) {
        this.setBounds(0, 0, 680, 220);
        this.setDefaultCloseOperation(3);
        JPanel jPanel = (JPanel)this.getContentPane();
        this.controll = wMV3Server;
        this.mp3Player = mP3Player;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JLabel jLabel = new JLabel("Source AVI");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        this.fileLabel = new JLabel();
        this.fileLabel.setPreferredSize(new Dimension(350, 22));
        gridBagLayout.setConstraints(this.fileLabel, gridBagConstraints);
        jPanel.add(this.fileLabel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.openButton = new JButton("Open");
        this.openButton.setActionCommand("Open");
        this.openButton.addActionListener(this);
        gridBagLayout.setConstraints(this.openButton, gridBagConstraints);
        jPanel.add(this.openButton);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JLabel jLabel2 = new JLabel("Video codec");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.videoCodec = new JLabel("---");
        gridBagLayout.setConstraints(this.videoCodec, gridBagConstraints);
        jPanel.add(this.videoCodec);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        JLabel jLabel3 = new JLabel("Audio codec");
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.audioCodec = new JLabel("---");
        gridBagLayout.setConstraints(this.audioCodec, gridBagConstraints);
        jPanel.add(this.audioCodec);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        this.asfCreationBar = new JProgressBar();
        this.asfCreationBar.setString("complete!");
        gridBagLayout.setConstraints(this.asfCreationBar, gridBagConstraints);
        jPanel.add(this.asfCreationBar);
        this.asfCreationBar.setMinimum(0);
        this.asfCreationBar.setEnabled(true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        this.createAsfButton = new JButton("Start");
        this.createAsfButton.setActionCommand("Start");
        this.createAsfButton.setToolTipText("convert AVI to Asf,  extract MP3, and start server");
        this.createAsfButton.addActionListener(this);
        gridBagLayout.setConstraints(this.createAsfButton, gridBagConstraints);
        jPanel.add(this.createAsfButton);
        this.createAsfButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        this.messageLabel = new JLabel("                                  ");
        gridBagLayout.setConstraints(this.messageLabel, gridBagConstraints);
        jPanel.add(this.messageLabel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.stopButton = new JButton("Stop");
        this.stopButton.setActionCommand("Stop");
        this.stopButton.addActionListener(this);
        gridBagLayout.setConstraints(this.stopButton, gridBagConstraints);
        jPanel.add(this.stopButton);
        this.stopButton.setEnabled(false);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagLayout.setConstraints(mP3Player, gridBagConstraints);
        jPanel.add(mP3Player);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.open = new JMenuItem("Open");
        this.open.setActionCommand("Open");
        this.open.addActionListener(this);
        jMenu.add(this.open);
        jMenu.addSeparator();
        this.convertToAsf = new JMenuItem("Convert video into Asf");
        this.convertToAsf.setActionCommand("convertVideo");
        this.convertToAsf.addActionListener(this);
        jMenu.add(this.convertToAsf);
        this.convertToAsf.setEnabled(false);
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(jMenu);
        this.pack();
        this.fd = new FileDialog((Frame)this, "Choose ASF", 0);
        Runtime.getRuntime().addShutdownHook(new Shutdown());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "Open") {
            this.fd.show();
            if (this.fd.getFile() != null) {
                String string = this.fd.getDirectory() + this.fd.getFile();
                File file = new File(string);
                this.controll.openAVI(file);
                this.fileLabel.setText(file.getName());
            }
        } else if (actionEvent.getActionCommand() == "Start") {
            this.controll.createAsfMP3();
        } else if (actionEvent.getActionCommand() == "Stop") {
            this.controll.stopServer();
        } else if (actionEvent.getActionCommand() == "convertVideo") {
            this.controll.createAsf();
        }
    }

    void setTextToFileLabel(String string) {
        this.fileLabel.setText(string);
    }

    void setTextToMessageLabel(String string) {
        this.messageLabel.setText(string);
    }

    void setTextToVideoCodecLabel(String string) {
        this.videoCodec.setText(string);
    }

    void setTextToAudioCodecLabel(String string) {
        this.audioCodec.setText(string);
    }

    void showAlert(Object object) {
        JOptionPane.showMessageDialog(this, object);
    }

    void setOpenButtonEnabled(boolean bl) {
        this.openButton.setEnabled(bl);
    }

    void setCreateAsfButtonEnabled(boolean bl) {
        this.createAsfButton.setEnabled(bl);
    }

    void setStopButtonEnabled(boolean bl) {
        this.stopButton.setEnabled(bl);
    }

    void setOpenMenuEnabled(boolean bl) {
        this.open.setEnabled(bl);
    }

    void setCreateAsfMenuEnabled(boolean bl) {
        this.convertToAsf.setEnabled(bl);
    }

    void setMaximumForAsfCreationBar(int n) {
        this.asfCreationBar.setMaximum(n);
    }

    void setValueForAsfCreationBar(int n) {
        this.asfCreationBar.setValue(n);
    }

    void showCompleteTextAsfCreationBar(boolean bl) {
        this.asfCreationBar.setStringPainted(bl);
    }

    void setToolTipTextToFileLabel(String string) {
        this.fileLabel.setToolTipText(string);
    }

    class Shutdown
    extends Thread {
        Shutdown() {
        }

        public void run() {
            WMV3ServerGUI.this.controll.doShutdownTask();
            WMV3ServerGUI.this.controll.savePrefs();
        }
    }
}

